# Two main variables are taken from repository:
# https://github.com/sublimehq/Packages/blob/master/CSS/
# which has the following license:
#############
# If not otherwise specified (see below), files in this repository fall under the following license:
#
#     Permission to copy, use, modify, sell and distribute this
#     software is granted. This software is provided "as is" without
#     express or implied warranty, and with no claim as to its
#     suitability for any purpose.
#
# An exception is made for files in readable text which contain their own license information, or files where an accompanying file exists (in the same directory) with a “-license” suffix added to the base-name name of the original file, and an extension of txt, html, or similar. For example “tidy” is accompanied by “tidy-license.txt”.
#############

common_values = {
        "absolute-size": [
            "xx-small",
            "x-small",
            "small",
            "medium",
            "large",
            "x-large",
            "xx-large",
        ],
        "absolute-weight": [
            "100",
            "200",
            "300",
            "400",
            "500",
            "600",
            "700",
            "800",
            "900",
            "normal",
            "bold",
        ],
        "axis": ["block", "inline", "vertical", "horizontal"],
        "baseline-position": ["firstbaseline", "lastbaseline", "baseline"],
        "basic-shape": [
            "<basic-shape-rect>",
            ["circle()", "circle($1)"],
            ["ellipse()", "ellipse($1)"],
            ["polygon()", "polygon($1)"],
        ],
        "basic-shape-rect": [
            ["inset()", "inset($1)"],
            ["rect()", "rect($1)"],
            ["xywh()", "xywh($1)"],
        ],
        "blend-mode": [
            "normal",
            "multiply",
            "screen",
            "overlay",
            "darken",
            "lighten",
            "color-dodge",
            "color-burn",
            "hard-light",
            "soft-light",
            "difference",
            "exclusion",
            "hue",
            "saturation",
            "color",
            "luminosity",
        ],
        "border-style": [
            "none",
            "hidden",
            "dotted",
            "dashed",
            "solid",
            "double",
            "groove",
            "ridge",
            "inset",
            "outset",
        ],
        "border-width": ["thin", "medium", "thick"],
        "break-before-after": [
            "always",
            "left",
            "right",
            "recto",
            "verso",
            "page",
            "column",
            "region",
        ],
        "break-inside": ["auto", "avoid", "avoid-page", "avoid-column", "avoid-region"],
        "calc": [
            ["acos()", "acos($1)"],
            ["asin()", "asin($1)"],
            ["atan()", "atan($1)"],
            ["atan2()", "atan2($1)"],
            ["calc()", "calc($1)"],
            ["clamp()", "clamp(${1:0}, ${2:0}, ${3:0})"],
            ["cos()", "cos($1)"],
            ["exp()", "exp($1)"],
            ["hypot()", "hypot($1)"],
            ["log()", "log($1)"],
            ["max()", "max(${1:0}, ${2:0})"],
            ["min()", "min(${1:0}, ${2:0})"],
            ["mod()", "mod(${1:0}, ${2:0})"],
            ["pow()", "pow(${1:0}, ${2:0})"],
            ["rem()", "rem(${1:0}, ${2:0})"],
            ["round()", "round(${1:0}, ${2:0}, ${3:0})"],
            ["sign()", "sign($1)"],
            ["sin()", "sin($1)"],
            ["sqrt()", "sqrt($1)"],
            ["tan()", "tan($1)"],
        ],
        "caret-color": ["auto", "<color>"],
        "caret-shape": ["auto", "bar", "block", "underscore"],
        "color": [
            "currentColor",
            "transparent",
            ["color()", "color($1)"],
            ["color-mix()", "color-mix($1, $2)"],
            ["rgb()", "rgb(${1:0}, ${2:0}, ${3:0}${4: / ${5:1.0}})"],
            ["rgba()", "rgba(${1:0}, ${2:0}, ${3:0}, ${4:1.0})"],
            ["hsl()", "hsl(${1:0}, ${2:100%}, ${3:50%}${4: / ${5:1.0}})"],
            ["hsla()", "hsla(${1:0}, ${2:100%}, ${3:50%}, ${4:1.0})"],
            ["hwb()", "hwb(${1:0}, ${2:100%}, ${3:50%}${4: / ${5:1.0}})"],
            ["lab()", "lab(${1:0%}, ${2:0}, ${3:0}${4: / ${5:1.0}})"],
            ["lch()", "lch(${1:0%}, ${2:0.0}, ${3:0.0}${4: / ${5:1.0}})"],
            ["light-dark()", "light-dark(${1}, ${2})"],
            ["oklab()", "oklab(${1:0%}, ${2:0}, ${3:0}${4: / ${5:1.0}})"],
            ["oklch()", "oklch(${1:0%}, ${2:0.0}, ${3:0.0}${4: / ${5:1.0}})"],
            # Named colors
            "aliceblue",
            "antiquewhite",
            "aqua",
            "aquamarine",
            "azure",
            "beige",
            "bisque",
            "black",
            "blanchedalmond",
            "blue",
            "blueviolet",
            "brown",
            "burlywood",
            "cadetblue",
            "chartreuse",
            "chocolate",
            "coral",
            "cornflowerblue",
            "cornsilk",
            "crimson",
            "cyan",
            "darkblue",
            "darkcyan",
            "darkgoldenrod",
            "darkgray",
            "darkgrey",
            "darkgreen",
            "darkkhaki",
            "darkmagenta",
            "darkolivegreen",
            "darkorange",
            "darkorchid",
            "darkred",
            "darksalmon",
            "darkseagreen",
            "darkslateblue",
            "darkslategray",
            "darkslategrey",
            "darkturquoise",
            "darkviolet",
            "deeppink",
            "deepskyblue",
            "dimgray",
            "dimgrey",
            "dodgerblue",
            "firebrick",
            "floralwhite",
            "forestgreen",
            "fuchsia",
            "gainsboro",
            "ghostwhite",
            "gold",
            "goldenrod",
            "gray",
            "grey",
            "green",
            "greenyellow",
            "honeydew",
            "hotpink",
            "indianred",
            "indigo",
            "ivory",
            "khaki",
            "lavender",
            "lavenderblush",
            "lawngreen",
            "lemonchiffon",
            "lightblue",
            "lightcoral",
            "lightcyan",
            "lightgoldenrodyellow",
            "lightgray",
            "lightgrey",
            "lightgreen",
            "lightpink",
            "lightsalmon",
            "lightseagreen",
            "lightskyblue",
            "lightslategray",
            "lightslategrey",
            "lightsteelblue",
            "lightyellow",
            "lime",
            "limegreen",
            "linen",
            "magenta",
            "maroon",
            "mediumaquamarine",
            "mediumblue",
            "mediumorchid",
            "mediumpurple",
            "mediumseagreen",
            "mediumslateblue",
            "mediumspringgreen",
            "mediumturquoise",
            "mediumvioletred",
            "midnightblue",
            "mintcream",
            "mistyrose",
            "moccasin",
            "navajowhite",
            "navy",
            "oldlace",
            "olive",
            "olivedrab",
            "orange",
            "orangered",
            "orchid",
            "palegoldenrod",
            "palegreen",
            "paleturquoise",
            "palevioletred",
            "papayawhip",
            "peachpuff",
            "peru",
            "pink",
            "plum",
            "powderblue",
            "purple",
            "rebeccapurple",
            "red",
            "rosybrown",
            "royalblue",
            "saddlebrown",
            "salmon",
            "sandybrown",
            "seagreen",
            "seashell",
            "sienna",
            "silver",
            "skyblue",
            "slateblue",
            "slategray",
            "slategrey",
            "snow",
            "springgreen",
            "steelblue",
            "tan",
            "teal",
            "thistle",
            "tomato",
            "turquoise",
            "violet",
            "wheat",
            "white",
            "whitesmoke",
            "yellow",
            "yellowgreen",
        ],
        "color-interpolation-method": [
            "<rectangular-color-space>",
            "<polar-color-space>",
            "<hue-interpolation-method>",
            "in",
        ],
        "container-type": ["normal", "size", "inline-size"],
        "content-distribution": ["space-between", "space-around", "space-evenly", "stretch"],
        "content-position": ["center", "start", "end", "flex-start", "flex-end"],
        "counter-style": [["symbols()", "symbols($1)"]],
        "counter-symbols": [
            "cyclic",
            "numeric",
            "alphabetic",
            "symbolic",
            "additive",
            "fixed",
        ],
        "fill-rule": ["nonzero", "evenodd"],
        "filter-value": ["none", "<url>", "<filter-function>"],
        "filter-function": [
            ["blur()", "blur($1)"],
            ["brightness()", "brightness($1)"],
            ["contrast()", "contrast($1)"],
            ["drop-shadow()", "drop-shadow($1)"],
            ["grayscale()", "grayscale($1)"],
            ["hue-rotate()", "hue-rotate($1)"],
            ["invert()", "invert($1)"],
            ["opacity()", "opacity($1)"],
            ["saturate()", "saturate($1)"],
            ["sepia()", "sepia($1)"],
        ],
        "font-palette": [
            "normal",
            "light",
            "dark",
            ["palette-mix()", "palette-mix($1)"],
        ],
        "font-variant-alternates": [
            "normal",
            "historical-forms",
            ["stylistic()", "stylistic($1)"],
            ["styleset()", "styleset($1)"],
            ["character-variant()", "character-variant($1)"],
            ["swash()", "swash($1)"],
            ["ornaments()", "ornaments($1)"],
            ["annotation()", "annotation($1)"],
        ],
        "generic-font-name": ["serif", "sans-serif", "cursive", "fantasy", "monospace"],
        "gradient": [
            ["conic-gradient()", "conic-gradient($1)"],
            ["linear-gradient()", "linear-gradient($1)"],
            ["radial-gradient()", "radial-gradient($1)"],
            ["repeating-conic-gradient()", "repeating-conic-gradient($1)"],
            ["repeating-linear-gradient()", "repeating-linear-gradient($1)"],
            ["repeating-radial-gradient()", "repeating-radial-gradient($1)"],
        ],
        "grid": [
            ["repeat()", "repeat(${1:2}, ${2:1fr})"],
            ["minmax()", "minmax(${1:100px}, ${2:1fr})"],
        ],
        "hue-interpolation-method": [
            "shorter hue",
            "longer hue",
            "increasing hue",
            "decreasing hue",
            "hue"
        ],
        "image": [
            "<url>",
            ["image()", "image($1)"],
            ["image-set()", "image-set($1)"],
            ["element()", "element($1)"],
            ["paint()", "paint($1)"],
            ["cross-fade()", "cross-fade($1)"],
            ["linear-gradient()", "linear-gradient($1)"],
            ["repeating-linear-gradient()", "repeating-linear-gradient($1)"],
            ["radial-gradient()", "radial-gradient($1)"],
            ["repeating-radial-gradient()", "repeating-radial-gradient($1)"],
            ["conic-gradient()", "conic-gradient($1)"],
        ],
        "image-tags": ["ltr", "rtl"],
        "line-style": [
            "none",
            "hidden",
            "dotted",
            "dashed",
            "solid",
            "double",
            "groove",
            "ridge",
            "inset",
            "outset",
        ],
        "leader-type": ["dotted", "solid", "space"],
        "list-style-type": [
            "none",
            "inline",
            "disc",
            "circle",
            "square",
            "decimal",
            "decimal-leading-zero",
            "arabic-indic",
            "binary",
            "bengali",
            "cambodian",
            "khmer",
            "devanagari",
            "gujarati",
            "gurmukhi",
            "kannada",
            "lower-hexadecimal",
            "lao",
            "malayalam",
            "mongolian",
            "myanmar",
            "octal",
            "oriya",
            "persian",
            "urdu",
            "telugu",
            "tibetan",
            "thai",
            "upper-hexadecimal",
            "lower-roman",
            "upper-roman",
            "lower-greek",
            "lower-alpha",
            "lower-latin",
            "upper-alpha",
            "upper-latin",
            "afar",
            "ethiopic-halehame-aa-et",
            "ethiopic-halehame-aa-er",
            "amharic",
            "ethiopic-halehame-am-et",
            "amharic-abegede",
            "ethiopic-abegede-am-et",
            "cjk-earthly-branch",
            "cjk-heavenly-stem",
            "ethiopic",
            "ethiopic-halehame-gez",
            "ethiopic-abegede",
            "ethiopic-abegede-gez",
            "hangul-consonant",
            "hangul",
            "lower-norwegian",
            "oromo",
            "ethiopic-halehame-om-et",
            "sidama",
            "ethiopic-halehame-sid-et",
            "somali",
            "ethiopic-halehame-so-et",
            "tigre",
            "ethiopic-halehame-tig",
            "tigrinya-er",
            "ethiopic-halehame-ti-er",
            "tigrinya-er-abegede",
            "ethiopic-abegede-ti-er",
            "tigrinya-et",
            "ethiopic-halehame-ti-et",
            "tigrinya-et-abegede",
            "ethiopic-abegede-ti-et",
            "upper-greek",
            "upper-norwegian",
            "asterisks",
            "footnotes",
            "hebrew",
            "armenian",
            "lower-armenian",
            "upper-armenian",
            "georgian",
            "cjk-ideographic",
            "hiragana",
            "katakana",
            "hiragana-iroha",
            "katakana-iroha",
        ],
        "overflow-position": ["unsafe", "safe"],
        "polar-color-space": ["hsl", "hwb", "lch", "oklch"],
        "position": ["<side-or-corner>", "center"],
        "radial-gradient-syntax": [
            "<radial-shape>",
            "<size>",
            "at",
            "<position>",
            "<color>",
        ],
        "radial-shape": [
            "circle",
            "ellipse"
        ],
        "ray-size": [
            "closest-side",
            "closest-corner",
            "farthest-side",
            "farthest-corner",
            "sides",
        ],
        "rectangular-color-space": [
            "srgb",
            "srgb-linear",
            "display-p3",
            "a98-rgb",
            "prophoto-rgb",
            "rec2020",
            "lab",
            "oklab",
            "xyz",
            "xyz-d50",
            "xyz-d65"
        ],
        "relative-size": ["larger", "smaller"],
        "relative-weight": ["bolder", "lighter"],
        "repeat-style": [
            "repeat",
            "repeat-x",
            "repeat-y",
            "space",
            "round",
            "no-repeat",
        ],
        "scroller": ["root", "nearest"],
        "self-position": [
            "center",
            "start",
            "end",
            "self-start",
            "self-end",
            "flex-start",
            "flex-end",
        ],
        "single-animation-composition": [
            "replace",
            "add",
            "accumulate"
        ],
        "single-animation-direction": [
            "normal",
            "reverse",
            "alternate",
            "alternate-reverse"
        ],
        "single-animation-fill-mode": [
            "none",
            "forwards",
            "backwards",
            "both"
        ],
        "single-animation-iteration-count": [
            "infinite",
            "<calc>"
        ],
        "single-animation-play-state": [
            "running",
            "paused"
        ],
        "single-animation-timeline": [
            "auto",
            "none",
            ["scroll()", "scroll($1)"],
            ["view()", "view($1)"]
        ],
        "shape-box": ["<visual-box>", "margin-box"],
        "shape-radius": ["closest-side", "farthest-side"],
        "side-or-corner": ["left", "right", "top", "bottom"],
        "symbols-type": ["cyclic", "numeric", "alphabetic", "symbolic", "fixed"],
        "text-box-edge": ["auto", "<text-edge>"],
        "text-box-trim": ["none", "trim-start", "trim-end", "trim-both"],
        "text-edge": [
            "cap",
            "ex",
            "ideographic",
            "ideographic-ink",
            "text",
            "alphabetic",
            "ideographic",
            "ideographic-ink",
        ],
        "text-wrap-mode": ["wrap", "nowrap"],
        "text-wrap-style": ["balance", "stable", "pretty"],
        "timing-function": [
            "linear",
            "ease",
            "ease-in",
            "ease-out",
            "ease-in-out",
            "step-start",
            "step-end",
            ["cubic-bezier()", "cubic-bezier(${1:0.0}, ${2:0.0}, ${3:1.0}, ${4:1.0})"],
            ["steps()", "steps(${1:2}, ${2:start})"],
        ],
        "type-or-unit": [
            "string",
            "color",
            "url",
            "integer",
            "number",
            "length",
            "angle",
            "time",
            "frequency",
            "cap",
            "ch",
            "em",
            "ex",
            "ic",
            "lh",
            "rlh",
            "rem",
            "vb",
            "vi",
            "vw",
            "vh",
            "vmin",
            "vmax",
            "mm",
            "Q",
            "cm",
            "in",
            "pt",
            "pc",
            "px",
            "deg",
            "grad",
            "rad",
            "turn",
            "ms",
            "s",
            "Hz",
            "kHz",
            "%",
        ],
        "url": [["url()", "url($1)"]],
        "visual-box": ["content-box", "padding-box", "border-box"],
        "white-space-collapse": [
            "collapse",
            "preserve",
            "preserve-breaks",
            "preserve-spaces",
            "break-spaces"
        ],
    }


props = {
        "accent-color": ["auto", "<calc>", "<color>"],
        "additive-symbols": [],
        "align-content": [
            "normal",
            "<baseline-position>",
            "<content-distribution>",
            "<content-position>",
            "<overflow-position>",
        ],
        "align-items": [
            "normal",
            "stretch",
            "<baseline-position>",
            "<overflow-position>",
            "<self-position>",
        ],
        "align-self": [
            "auto",
            "normal",
            "stretch",
            "<baseline-position>",
            "<overflow-position>",
            "<self-position>",
        ],
        "align-tracks": [
            "normal",
            "<baseline-position>",
            "<content-distribution>",
            "<overflow-position>",
            "<content-position>",
        ],
        "alignment-baseline": [
            "baseline",
            "alphabetic",
            "ideographic",
            "middle",
            "central",
            "mathematical",
            "text-before-edge",
            "text-after-edge",
        ],
        "all": [],
        "alt": [],
        "animation": [
            "<animation-direction>",
            "<calc>",
            "<timing>",
            "none",
            "infinite",
            "forwards",
            "backwards",
            "both",
            "running",
            "paused",
        ],
        "animation-composition": ["<single-animation-composition>"],
        "animation-delay": ["<calc>"],
        "animation-direction": ["<single-animation-direction>"],
        "animation-duration": ["<calc>"],
        "animation-fill-mode": ["<single-animation-fill-mode>"],
        "animation-iteration-count": ["<single-animation-iteration-count>"],
        "animation-name": ["none"],
        "animation-play-state": ["<single-animation-play-state>"],
        "animation-timing-function": ["<calc>", "<timing>"],
        "animation-timeline": ["<single-animation-timeline>"],
        "appearance": ["auto", "menulist-button", "none", "textfield"],
        "aspect-ratio": ["auto"],
        "backdrop-filter": ["<filter-value>"],
        "backface-visibility": ["visible", "hidden"],
        "background": [
            "<calc>",
            "<color>",
            "<gradient>",
            "<position>",
            "<repeat-style>",
            "<url>",
            "fixed",
            "scroll",
        ],
        "background-attachment": ["fixed", "local", "scroll"],
        "background-blend-mode": ["<blend-mode>"],
        "background-clip": [
            "<visual-box>",
            "border-area",
            "text",
        ],
        "background-color": ["<color>"],
        "background-image": ["<url>", "none"],
        "background-origin": [
            "<visual-box>",
        ],
        "background-position": ["<calc>", "<position>"],
        "background-position-x": [
            "<calc>",
            "center",
            "left",
            "right",
            "x-end",
            "x-start",
        ],
        "background-position-y": [
            "<calc>",
            "bottom",
            "center",
            "top",
            "y-end",
            "y-start",
        ],
        "background-repeat": ["<repeat-style>"],
        "background-size": [
            "<calc>",
            "auto",
            "cover",
            "contain",
        ],
        "baseline-shift": ["<calc>", "sub", "super", "baseline"],
        "behavior": [],
        "bleed": ["auto"],
        "block-size": ["<calc>", "auto"],
        "border": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-block": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-block-color": ["<color>"],
        "border-block-end": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-block-end-color": ["<color>"],
        "border-block-end-style": ["<border-style>"],
        "border-block-end-width": ["<border-width>", "<calc>"],
        "border-block-start": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-block-start-color": ["<color>"],
        "border-block-start-style": ["<border-style>"],
        "border-block-start-width": ["<border-width>", "<calc>"],
        "border-block-style": ["<border-style>"],
        "border-block-width": ["<border-width>", "<calc>"],
        "border-bottom": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-bottom-color": ["<color>"],
        "border-bottom-left-radius": ["<calc>"],
        "border-bottom-right-radius": ["<calc>"],
        "border-bottom-style": ["<border-style>"],
        "border-bottom-width": ["<border-width>", "<calc>"],
        "border-collapse": ["collapse", "separate"],
        "border-color": ["<color>"],
        "border-end-end-radius": ["<calc>"],
        "border-end-start-radius": ["<calc>"],
        "border-image": [
            "<calc>",
            "<url>",
            "auto",
            "fill",
            "none",
            "repeat",
            "round",
            "space",
            "stretch",
        ],
        "border-image-outset": [],
        "border-image-repeat": ["stretch", "repeat", "round", "space"],
        "border-image-slice": [
            "<calc>",
            "fill",
        ],
        "border-image-source": ["none", "<url>"],
        "border-image-width": ["<calc>", "auto"],
        "border-inline": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-inline-color": ["<color>"],
        "border-inline-end": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-inline-end-color": ["<color>"],
        "border-inline-end-style": ["<border-style>"],
        "border-inline-end-width": ["<border-width>", "<calc>"],
        "border-inline-start": [
            "<border-width>",
            "<border-style>",
            "<calc>",
            "<color>",
        ],
        "border-inline-start-color": ["<color>"],
        "border-inline-start-style": ["<border-style>"],
        "border-inline-start-width": ["<border-width>", "<calc>"],
        "border-inline-style": ["<border-style>"],
        "border-inline-width": ["<border-width>", "<calc>"],
        "border-left": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-left-color": ["<color>"],
        "border-left-style": ["<border-style>"],
        "border-left-width": ["<border-width>", "<calc>"],
        "border-radius": ["<calc>"],
        "border-right": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-right-color": ["<color>"],
        "border-right-style": ["<border-style>"],
        "border-right-width": ["<border-width>", "<calc>"],
        "border-spacing": [],
        "border-start-end-radius": ["<calc>"],
        "border-start-start-radius": ["<calc>"],
        "border-style": ["<border-style>"],
        "border-top": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "border-top-color": ["<color>"],
        "border-top-left-radius": ["<calc>"],
        "border-top-right-radius": ["<calc>"],
        "border-top-style": ["<border-style>"],
        "border-top-width": ["<border-width>", "<calc>"],
        "border-width": ["<border-width>", "<calc>"],
        "bottom": ["<calc>", "auto"],
        "box-align": ["baseline", "center", "end", "start", "stretch"],
        "box-decoration-break": ["slice", "clone"],
        "box-direction": ["normal", "reverse"],
        "box-flex": ["<calc>"],
        "box-flex-group": ["<calc>"],
        "box-lines": ["multiple", "single"],
        "box-ordinal-group": ["<calc>"],
        "box-orient": ["block-axis", "horizontal", "inline-axis", "vertical"],
        "box-pack": ["center", "end", "justify", "start"],
        "box-shadow": ["none", "inset", "<calc>", "<color>"],
        "box-sizing": ["content-box", "border-box"],
        "break-after": ["<break-before-after>", "<break-inside>"],
        "break-before": ["<break-before-after>", "<break-inside>"],
        "break-inside": ["<break-inside>"],
        "caption-side": ["top", "bottom"],
        "caret": ["<caret-color>", "<caret-shape>"],
        "caret-color": ["<caret-color>"],
        "caret-shape": ["<caret-shape>"],
        "clear": ["none", "left", "right", "both"],
        "clip": [["rect()", "rect(${1:0}, ${2:0}, ${3:0}, ${4:0})"], "auto"],
        "clip-path": ["none", "<url>", "<basic-shape>"],
        "clip-rule": ["nonzero", "evenodd"],
        "color": ["<color>"],
        "color-interpolation": ["auto", "sRGB", "linearRGB"],
        "color-interpolation-filters": ["auto", "sRGB", "linearRGB"],
        "color-scheme": ["normal", "light", "dark", "only"],
        "column-count": [
            "<calc>",
            "auto",
        ],
        "column-fill": ["auto", "balance"],
        "column-gap": [
            "<calc>",
            "normal",
        ],
        "column-rule": ["<border-width>", "<border-style>", "<calc>", "<color>"],
        "column-rule-color": ["<color>"],
        "column-rule-style": ["<border-style>"],
        "column-rule-width": ["<border-width>", "<calc>"],
        "column-span": ["<calc>", "none"],
        "column-width": [
            "<calc>",
            "auto",
        ],
        "columns": ["<calc>", "auto"],
        "container": ["<container-type>"],
        "container-name": ["none"],
        "container-type": ["<container-type>", "scroll-state"],
        "contain": ["content", "layout", "none", "paint", "inline-size", "size", "strict", "style"],
        "contain-intrinsic-size": ["none", "auto"],
        "contain-intrinsic-block-size": ["none", "auto"],
        "contain-intrinsic-height": ["none", "auto"],
        "contain-intrinsic-inline-size": ["none", "auto"],
        "contain-intrinsic-width": ["none", "auto"],
        "content": [
            "none",
            "normal",
            "<string>",
            "<url>",
            "open-quote",
            "close-quote",
            "no-open-quote",
            "no-close-quote",
            ["attr()", "attr($1)"],
            ["counter()", "counter($1)"],
        ],
        "content-visibility": ["auto", "hidden", "visible"],
        "counter-increment": [
            "<calc>",
            "none",
        ],
        "counter-reset": [
            "none",
        ],
        "counter-set": ["<calc>", "none"],
        "cursor": [
            "<url>",
            "auto",
            "default",
            "none",
            "context-menu",
            "help",
            "pointer",
            "progress",
            "wait",
            "cell",
            "crosshair",
            "text",
            "vertical-text",
            "alias",
            "copy",
            "move",
            "no-drop",
            "not-allowed",
            "e-resize",
            "n-resize",
            "ne-resize",
            "nw-resize",
            "s-resize",
            "se-resize",
            "sw-resize",
            "w-resize",
            "ew-resize",
            "ns-resize",
            "nesw-resize",
            "nwse-resize",
            "col-resize",
            "row-resize",
            "all-scroll",
            "zoom-in",
            "zoom-out",
        ],
        "cx": ["<calc>"],
        "cy": ["<calc>"],
        "d": ["none", ["path()", "path($1)"]],
        "direction": ["ltr", "rtl"],
        "display": [
            "none",
            "inline",
            "inline-block",
            "inline-table",
            "inline-flex",
            "inline-grid",
            "block",
            "contents",
            "list-item",
            "table",
            "table-cell",
            "table-column",
            "table-column-group",
            "table-footer-group",
            "table-header-group",
            "table-row",
            "table-row-group",
            "table-caption",
            "flex",
            "flow",
            "flow-root",
            "grid",
            "ruby",
            "ruby-base",
            "ruby-text",
            "ruby-base-container",
            "ruby-text-container",
            "run-in",
        ],
        "dominant-baseline": [
            "auto",
            "text-bottom",
            "alphabetic",
            "ideographic",
            "middle",
            "central",
            "mathematical",
            "hanging",
            "text-top"
        ],
        "empty-cells": ["show", "hide"],
        "enable-background": ["accumulate", "new"],
        "fallback": [],
        "field-sizing": ["content", "fixed"],
        "fill": ["<color>", "none", "context-fill", "context-stroke"],
        "fill-opacity": [
            "<calc>",
        ],
        "fill-rule": ["nonzero", "evenodd"],
        "filter": ["<filter-value>"],
        "flex": [
            "<calc>",
            "none",
            "auto",
        ],
        "flex-basis": [
            "<calc>",
            "auto",
        ],
        "flex-direction": ["row", "row-reverse", "column", "column-reverse"],
        "flex-flow": [
            "row",
            "row-reverse",
            "column",
            "column-reverse",
            "nowrap",
            "wrap",
            "wrap-reverse",
        ],
        "flex-grow": [
            "<calc>",
        ],
        "flex-shrink": [
            "<calc>",
        ],
        "flex-wrap": ["nowrap", "wrap", "wrap-reverse"],
        "float": [
            "left",
            "right",
            "none",
            "inline-start",
            "inline-end",
        ],
        "flood-color": ["<color>"],
        "flood-opacity": [
            "<calc>",
        ],
        "font": [
            "<absolute-weight>",
            "<calc>",
            "<generic-font-name>",
            "<relative-weight>",
            "caption",
            "icon",
            "italic",
            "menu",
            "message-box",
            "oblique",
            "small-caps",
            "small-caption",
            "status-bar",
        ],
        "font-display": ["auto", "block", "fallback", "optional", "swap"],
        "font-family": ["<generic-font-name>"],
        "font-feature-settings": ["normal", "<string>"],
        "font-kerning": ["auto", "normal", "none"],
        "font-language-override": ["normal", "<string>"],
        "font-optical-sizing": ["auto", "none"],
        "font-palette":["<font-palette>"],
        "font-size": [
            "<calc>",
            "<absolute-size>",
            "<relative-size>",
        ],
        "font-size-adjust": [
            "<calc>",
            "ex-height",
            "cap-height",
            "ch-width",
            "ic-width",
            "ic-height",
            "from-font",
            "none",
        ],
        "font-smooth": ["always", "auto", "never"],
        "font-stretch": [
            "normal",
            "semi-condensed",
            "condensed",
            "extra-condensed",
            "ultra-condensed",
            "semi-expanded",
            "expanded",
            "extra-expanded",
            "ultra-expanded",
        ],
        "font-style": ["normal", "italic", "oblique"],
        "font-synthesis": ["none", "weight", "style", "small-caps"],
        "font-synthesis-small-caps": ["auto", "none"],
        "font-synthesis-style": ["auto", "none"],
        "font-synthesis-weight": ["auto", "none"],
        "font-variant": ["normal", "small-caps"],
        "font-variant-alternates": ["<font-variant-alternates>"],
        "font-variant-caps": [
            "normal",
            "small-caps",
            "all-small-caps",
            "petite-caps",
            "all-petite-caps",
            "unicase",
            "titling-case",
        ],
        "font-variant-east-asian": [
            "normal",
            "ruby",
            "jis78",
            "jis83",
            "jis90",
            "jis04",
            "simplified",
            "traditional",
        ],
        "font-variant-emoji": ["normal", "text", "emoji", "unicode"],
        "font-variant-ligatures": [
            "normal",
            "none",
            "common-ligatures",
            "no-common-ligatures",
            "discretionary-ligatures",
            "no-discretionary-ligatures",
            "historical-ligatures",
            "no-historical-ligatures",
            "contextual",
            "no-contextual",
        ],
        "font-variant-numeric": [
            "normal",
            "ordinal",
            "slashed-zero",
            "lining-nums",
            "oldstyle-nums",
            "proportional-nums",
            "tabular-nums",
            "diagonal-fractions",
            "stacked-fractions",
        ],
        "font-variant-position": ["normal", "sub", "super"],
        "font-variation-settings": ["normal"],
        "font-weight": ["<absolute-weight>", "<relative-weight>"],
        "forced-color-adjust": ["auto", "none", "preserve-parent-color"],
        "gap": [
            "<calc>",
        ],
        "glyph-orientation-horizontal": ["auto"],
        "glyph-orientation-vertical": ["auto"],
        "grid": [
            "<calc>",
            "<grid>",
            "auto",
            "auto-flow",
            "dense",
            "span",
        ],
        "grid-area": [
            "<calc>",
            "<grid>",
            "auto",
            "span",
        ],
        "grid-auto-columns": [
            "<calc>",
            "<grid>",
            "auto",
        ],
        "grid-auto-flow": ["row", "column", "dense"],
        "grid-auto-rows": [
            "<calc>",
            "<grid>",
            "auto",
        ],
        "grid-column": [
            "<calc>",
            "auto",
            "span",
        ],
        "grid-column-end": [
            "<calc>",
            "auto",
            "span",
        ],
        "grid-column-gap": [
            "<calc>",
            "auto",
            "span",
        ],
        "grid-column-start": [
            "<calc>",
            "auto",
            "span",
        ],
        "grid-gap": [
            "<calc>",
        ],
        "grid-row": [
            "<calc>",
            "auto",
            "span",
        ],
        "grid-row-end": [
            "<calc>",
            "auto",
            "span",
        ],
        "grid-row-gap": [
            "<calc>",
        ],
        "grid-row-start": [
            "<calc>",
            "auto",
            "span",
        ],
        "grid-template": [
            "<calc>",
            "<grid>",
            "auto",
            "max-content",
            "min-content",
            "none",
            "subgrid",
        ],
        "grid-template-areas": [
            "auto",
            "<calc>",
            "<grid>",
        ],
        "grid-template-columns": [
            "auto",
            "<calc>",
            "<grid>",
        ],
        "grid-template-rows": [
            "auto",
            "<calc>",
            "<grid>",
        ],
        "hanging-punctuation": ["allow-end", "first", "force-end", "last", "none"],
        "height": ["<calc>", "auto", "fit-content"],
        "hyphens": ["none", "manual", "auto"],
        "hyphenate-character": ["auto"],
        "hyphenate-limit-chars": ["auto"],
        "image-orientation": ["flip", "from-image"],
        "image-rendering": ["auto", "crisp-edges", "pixelated", "smooth"],
        "image-resolution": ["from-image"],
        "ime-mode": ["auto", "normal", "active", "inactive", "disabled"],
        "inherits": ["false", "true"],
        "initial-letter": ["<calc>", "normal"],
        "initial-letter-align": ["alphabetic", "auto", "hanging", "ideographic"],
        "initial-value": [
            "<calc>",
        ],
        "inline-size": ["<calc>", "auto"],
        "inset": [],
        "inset-block": [],
        "inset-block-end": [],
        "inset-block-start": [],
        "inset-inline": [],
        "inset-inline-end": [],
        "inset-inline-start": [],
        "isolation": ["auto", "isolation"],
        "interpolate-size": ["numeric-only", "allow-keywords"],
        "justify-content": [
            "left",
            "normal",
            "right",
            "<content-distribution>",
            "<content-position>",
            "<overflow-position>",
        ],
        "justify-items": [
            "left",
            "legacy",
            "normal",
            "right",
            "stretch",
            "<baseline-position>",
            "<overflow-position>",
            "<self-position>",
        ],
        "justify-self": [
            "auto",
            "left",
            "normal",
            "right",
            "stretch",
            "<baseline-position>",
            "<overflow-position>",
            "<self-position>",
        ],
        "justify-tracks": [
            "left",
            "normal",
            "right",
            "<content-distribution>",
            "<content-position>",
            "<overflow-position>",
        ],
        "kerning": ["<calc>", "auto"],
        "left": ["<calc>", "auto"],
        "letter-spacing": [
            "<calc>",
            "normal",
        ],
        "lighting-color": ["<color>"],
        "line-break": ["anywhere", "auto", "loose", "normal", "strict"],
        "line-clamp": ["<calc>", "none"],
        "line-height": [
            "<calc>",
            "normal",
        ],
        "line-height-step": [
            "<calc>",
        ],
        "list-style": [
            "<list-style-type>",
            "<url>",
            "inside",
            "outside",
        ],
        "list-style-image": ["<url>", "none"],
        "list-style-position": ["inside", "outside"],
        "list-style-type": ["<list-style-type>"],
        "margin": [
            "<calc>",
            "auto",
        ],
        "margin-block": [
            "<calc>",
        ],
        "margin-block-end": ["<calc>", "auto"],
        "margin-block-start": ["<calc>", "auto"],
        "margin-bottom": [
            "<calc>",
            "auto",
        ],
        "margin-inline": [
            "<calc>",
        ],
        "margin-inline-end": ["<calc>", "auto"],
        "margin-inline-start": ["<calc>", "auto"],
        "margin-left": [
            "<calc>",
            "auto",
        ],
        "margin-right": [
            "<calc>",
            "auto",
        ],
        "margin-top": [
            "<calc>",
            "auto",
        ],
        "margin-trim": ["all", "in-flow", "none"],
        "marker": ["<url>", "none"],
        "marker-end": ["<url>", "none"],
        "marker-mid": ["<url>", "none"],
        "marker-start": ["<url>", "none"],
        "marks": ["crop", "cross", "none"],
        "mask": ["<calc>", "<url>", "none"],
        "mask-border": [
            "<calc>",
        ],
        "mask-border-mode": ["alpha", "luminance"],
        "mask-border-outset": [],
        "mask-border-repeat": ["repeat", "round", "space", "stretch"],
        "mask-border-slice": [],
        "mask-border-source": ["none"],
        "mask-border-width": ["<calc>", "auto"],
        "mask-clip": ["no-clip"],
        "mask-composite": [],
        "mask-image": ["<url>", "none"],
        "mask-mode": ["alpha", "auto", "luminance"],
        "mask-origin": [
            "<calc>",
        ],
        "mask-position": [
            "<calc>",
        ],
        "mask-repeat": ["<repeat-style>"],
        "mask-size": ["<calc>", "auto", "contain", "cover"],
        "mask-type": ["luminance", "alpha"],
        "masonry-auto-flow": ["definite-first", "next", "ordered", "pack"],
        "math-depth": ["auto-add", ["add()", "add($1)"]],
        "math-shift": ["compact", "normal"],
        "math-style": ["compact", "normal"],
        "max-block-size": ["<calc>", "none"],
        "max-height": ["<calc>", "fit-content", "none"],
        "max-inline-size": ["<calc>", "none"],
        "max-lines": ["<calc>", "none"],
        "max-width": ["<calc>", "fit-content", "none"],
        "max-zoom": ["<calc>", "auto"],
        "min-block-size": [
            "<calc>",
        ],
        "min-height": ["<calc>", "fit-content"],
        "min-inline-size": [
            "<calc>",
        ],
        "min-width": ["<calc>", "fit-content"],
        "min-zoom": ["<calc>", "auto"],
        "mix-blend-mode": ["<blend-mode>", "plus-lighter"],
        "motion": [["path()", "path($1)"], "auto", "none", "reverse"],
        "motion-offset": [
            "<calc>",
        ],
        "motion-path": [["path()", "path($1)"], "none"],
        "motion-rotation": ["auto", "reverse"],
        "nav-down": ["auto", "current", "root"],
        "nav-index": ["auto"],
        "nav-left": ["auto", "current", "root"],
        "nav-right": ["auto", "current", "root"],
        "nav-up": ["auto", "current", "root"],
        "negative": [],
        "object-fit": ["fill", "contain", "cover", "none", "scale-down"],
        "object-position": ["<calc>", "<position>"],
        "offset": [
            "<calc>",
        ],
        "offset-anchor": ["<calc>", "auto"],
        "offset-block-end": ["<calc>", "auto"],
        "offset-block-start": ["<calc>", "auto"],
        "offset-distance": [
            "<calc>",
        ],
        "offset-inline-end": ["<calc>", "auto"],
        "offset-inline-start": ["<calc>", "auto"],
        "offset-path": ["<calc>", "none", ["ray()", "ray($1)"]],
        "offset-position": ["<calc>", "auto", "normal"],
        "offset-rotate": ["<calc>", "auto", "reverse"],
        "opacity": [
            "<calc>",
        ],
        "order": [],
        "orientation": ["auto", "landscape", "portrait"],
        "orphans": [],
        "outline": [
            "<color>",
            "<border-style>",
            "<border-width>",
            "<calc>",
        ],
        "outline-color": ["<color>", "invert"],
        "outline-offset": ["<calc>"],
        "outline-style": ["<border-style>"],
        "outline-width": [
            "<border-width>",
            "<calc>",
        ],
        "overflow": ["visible", "hidden", "scroll", "auto"],
        "overflow-anchor": ["auto", "none"],
        "overflow-block": ["auto", "clip", "hidden", "scroll", "visible"],
        "overflow-clip-box": ["content-box", "padding-box"],
        "overflow-inline": ["auto", "clip", "hidden", "scroll", "visible"],
        "overflow-wrap": ["normal", "break-word"],
        "overflow-x": ["visible", "hidden", "scroll", "auto"],
        "overflow-y": ["visible", "hidden", "scroll", "auto"],
        "overscroll-behavior": ["auto", "contain", "none"],
        "overscroll-behavior-block": ["auto", "contain", "none"],
        "overscroll-behavior-inline": ["auto", "contain", "none"],
        "overscroll-behavior-x": ["auto", "contain", "none"],
        "overscroll-behavior-y": ["auto", "contain", "none"],
        "pad": [
            "<calc>",
        ],
        "padding": ["<calc>", "auto"],
        "padding-block": [
            "<calc>",
        ],
        "padding-block-end": [
            "<calc>",
        ],
        "padding-block-start": [
            "<calc>",
        ],
        "padding-bottom": ["<calc>", "auto"],
        "padding-inline": [
            "<calc>",
        ],
        "padding-inline-end": [
            "<calc>",
        ],
        "padding-inline-start": [
            "<calc>",
        ],
        "padding-left": ["<calc>", "auto"],
        "padding-right": ["<calc>", "auto"],
        "padding-top": ["<calc>", "auto"],
        "page": ["auto"],
        "page-break-after": ["auto", "always", "avoid", "left", "right"],
        "page-break-before": ["auto", "always", "avoid", "left", "right"],
        "page-break-inside": ["avoid", "auto"],
        "page-orientation": ["upright", "rotate-left", "rotate-right"],
        "paint-order": ["normal", "fill", "stroke", "markers"],
        "perspective": ["none"],
        "perspective-origin": ["<calc>", "<position>"],
        "place-content": [],
        "place-items": [],
        "place-self": [],
        "pointer-events": [
            "auto",
            "none",
            "all",
            "visiblePainted",
            "visibleFill",
            "visibleStroke",
            "visible",
            "painted",
            "fill",
            "stroke",
        ],
        "position": ["static", "relative", "absolute", "fixed", "sticky"],
        "prefix": [],
        "print-color-adjust": ["economy", "exact"],
        "quotes": ["none", "<string>"],
        "r": ["<calc>"],
        "range": ["auto", "infinite"],
        "resize": ["none", "both", "horizontal", "vertical"],
        "right": ["<calc>", "auto"],
        "rotate": ["<calc>", "none"],
        "row-gap": ["<calc>", "normal"],
        "ruby-align": [
            "auto",
            "center",
            "distribute-letter",
            "distribute-space",
            "left",
            "line-edge",
            "right",
            "space-around",
            "space-between",
            "start",
        ],
        "ruby-merge": ["auto", "collapse", "separate"],
        "ruby-overhang": ["auto", "end", "none", "start"],
        "ruby-position": [
            "after",
            "before",
            "inline",
            "inter-character",
            "over",
            "right",
            "under",
        ],
        "ruby-span": [["attr()", "attr($1)"], "<calc>", "none"],
        "rx": ["<calc>"],
        "ry": ["<calc>"],
        "scale": ["<calc>", "none"],
        "scroll-behavior": ["auto", "smooth"],
        "scroll-margin": ["<calc>"],
        "scroll-margin-block": ["<calc>"],
        "scroll-margin-block-end": ["<calc>"],
        "scroll-margin-block-start": ["<calc>"],
        "scroll-margin-bottom": ["<calc>"],
        "scroll-margin-inline": ["<calc>"],
        "scroll-margin-inline-end": ["<calc>"],
        "scroll-margin-inline-start": ["<calc>"],
        "scroll-margin-left": ["<calc>"],
        "scroll-margin-right": ["<calc>"],
        "scroll-margin-top": ["<calc>"],
        "scroll-padding": ["auto", "<calc>"],
        "scroll-padding-block": ["auto", "<calc>"],
        "scroll-padding-block-end": ["auto", "<calc>"],
        "scroll-padding-block-start": ["auto", "<calc>"],
        "scroll-padding-bottom": ["auto", "<calc>"],
        "scroll-padding-inline": ["auto", "<calc>"],
        "scroll-padding-inline-end": ["auto", "<calc>"],
        "scroll-padding-inline-start": ["auto", "<calc>"],
        "scroll-padding-left": ["auto", "<calc>"],
        "scroll-padding-right": ["auto", "<calc>"],
        "scroll-padding-top": ["auto", "<calc>"],
        "scroll-snap-align": ["center", "end", "none", "start"],
        "scroll-snap-coordinate": ["none"],
        "scroll-snap-destination": [],
        "scroll-snap-points-x": [["repeat()", "repeat($1)"], "none"],
        "scroll-snap-points-y": [["repeat()", "repeat($1)"], "none"],
        "scroll-snap-stop": ["always", "normal"],
        "scroll-snap-type": [
            "block",
            "both",
            "inline",
            "mandatory",
            "none",
            "proximity",
        ],
        "scroll-snap-type-x": ["mandatory", "none", "proximity"],
        "scroll-snap-type-y": ["mandatory", "none", "proximity"],
        "scroll-timeline": ["none", "<axis>"],
        "scroll-timeline-axis": ["<axis>"],
        "scroll-timeline-name": ["none"],
        "scrollbar-3dlight-color": ["<color>"],
        "scrollbar-arrow-color": ["<color>"],
        "scrollbar-base-color": ["<color>"],
        "scrollbar-color": ["auto", "dark", "light", "<color>"],
        "scrollbar-darkshadow-color": ["<color>"],
        "scrollbar-face-color": ["<color>"],
        "scrollbar-gutter": ["always", "auto", "stable"],
        "scrollbar-highlight-color": ["<color>"],
        "scrollbar-shadow-color": ["<color>"],
        "scrollbar-track-color": ["<color>"],
        "scrollbar-width": ["auto", "none", "thin", "<calc>"],
        "shape-image-threshold": [],
        "shape-margin": ["<calc>"],
        "shape-outside": [
            "none",
            "<shape-box>",
            "<basic-shape>",
            "<url>",
        ],
        "shape-rendering": [
            "auto",
            "optimizeSpeed",
            "crispEdges",
            "geometricPrecision",
        ],
        "size": [
            "a3",
            "a4",
            "a5",
            "b4",
            "b5",
            "jis-b4",
            "jis-b5",
            "landscape",
            "ledger",
            "legal",
            "letter",
            "portrait",
        ],
        "speak-as": ["auto", "bullets", "numbers", "spell-out", "words"],
        "src": [["format()", "format($1)"], ["local()", "local($1)"], "<url>"],
        "stop-color": ["<color>"],
        "stop-opacity": ["<calc>"],
        "stroke": ["<calc>", "<color>"],
        "stroke-dasharray": ["none", "<calc>"],
        "stroke-dashoffset": ["<calc>"],
        "stroke-linecap": ["butt", "round", "square"],
        "stroke-linejoin": ["miter", "miter-clip", "round", "bevel", "arcs"],
        "stroke-miterlimit": ["<calc>"],
        "stroke-opacity": ["<calc>"],
        "stroke-width": ["<calc>"],
        "suffix": [],
        "symbols": [],
        "syntax": [],
        "system": ["<counter-symbols>"],
        "tab-size": ["<calc>"],
        "table-layout": ["auto", "fixed"],
        "text-align": ["left", "right", "center", "justify", "justify-all"],
        "text-align-last": ["start", "end", "left", "right", "center", "justify"],
        "text-anchor": ["start", "middle", "end"],
        "text-box": ["<text-box-trim", "<text-box-edge>", "normal"],
        "text-box-edge": ["<text-box-edge>"],
        "text-box-trim": ["<text-box-trim"],
        "text-combine-upright": ["all", "digits", "none"],
        "text-decoration": ["none", "underline", "overline", "line-through", "blink"],
        "text-decoration-color": ["<color>"],
        "text-decoration-line": ["none", "underline", "overline", "line-through"],
        "text-decoration-skip": [
            "box-decoration",
            "edges",
            "leading-spaces",
            "none",
            "objects",
            "spaces",
            "trailing-spaces",
        ],
        "text-decoration-skip-ink": ["all", "auto", "none"],
        "text-decoration-style": ["solid", "double", "dotted", "dashed", "wavy"],
        "text-decoration-thickness": ["auto", "from-font"],
        "text-emphasis": [
            "<color>",
            "<string>",
            "<text-emphasis-style>",
        ],
        "text-emphasis-color": [
            "<color>",
        ],
        "text-emphasis-position": ["auto", "over left", "under left", "over right", "under right"],
        "text-emphasis-style": ["<string>", "<text-emphasis-style>"],
        "text-indent": ["<calc>", "hanging", "each-line"],
        "text-justify": [
            "auto",
            "distribute",
            "distribute-all-lines",
            "inter-character",
            "inter-cluster",
            "inter-ideograph",
            "inter-word",
            "kashida",
            "newspaper",
            "none",
        ],
        "text-orientation": ["mixed", "upright", "sideways", "use-glyph-orientation"],
        "text-overflow": ["<string>", "clip", "ellipsis"],
        "text-rendering": [
            "auto",
            "optimizeSpeed",
            "optimizeLegibility",
            "geometricPrecision",
        ],
        "text-shadow": ["<color>", "none"],
        "text-size-adjust": ["<calc>", "auto", "none"],
        "text-transform": [
            "capitalize",
            "full-size-kana",
            "full-width",
            "uppercase",
            "lowercase",
            "none",
        ],
        "text-underline-offset": ["<calc>", "auto"],
        "text-underline-position": ["auto", "under", "left", "right"],
        "text-wrap": ["<text-wrap-mode>", "<text-wrap-style>"],
        "text-wrap-mode": ["<text-wrap-mode>"],
        "text-wrap-style": ["<text-wrap-style>"],
        "top": ["<calc>", "auto"],
        "touch-action": [
            "auto",
            "cross-slide-x",
            "cross-slide-y",
            "double-tap-zoom",
            "manipulation",
            "none",
            "pan-down",
            "pan-left",
            "pan-right",
            "pan-up",
            "pan-x",
            "pan-y",
            "pinch-zoom",
        ],
        "transform": [
            "none",
            ["matrix()", "matrix(${1:1}, ${2:1}, ${3:1}, ${4:1}, ${5:2}, ${6:2})"],
            [
                "matrix3d()",
                "matrix3d(${1:1}, ${2:1}, ${3:0}, ${4:0}, ${5:1}, ${6:1}, ${7:0}, ${8:0}, ${9:0}, ${10:0}, ${11:1}, ${12:0}, ${13:2}, ${14:2}, ${15:0}, ${16:1})",
            ],
            ["perspective()", "perspective(${1:0})"],
            ["rotate()", "rotate(${1:45deg})"],
            ["rotate3d()", "rotate3d(${1:0}, ${2:0}, ${3:1}, ${4:45deg})"],
            ["rotateX()", "rotateX(${1:45deg})"],
            ["rotateY()", "rotateY(${1:45deg})"],
            ["rotateZ()", "rotateZ(${1:45deg})"],
            ["scale()", "scale(${1:1.0})"],
            ["scale3d()", "scale3d(${1:1.0}, ${2:1.0}, ${3:1.0})"],
            ["scaleX()", "scaleX(${1:1.0})"],
            ["scaleY()", "scaleY(${1:1.0})"],
            ["scaleZ()", "scaleZ(${1:1.0})"],
            ["skew()", "skew(${1:10deg})"],
            ["skewX()", "skewX(${1:10deg})"],
            ["skewY()", "skewY(${1:10deg})"],
            ["translate()", "translate(${1:10px})"],
            ["translate3d()", "translate3d(${1:10px}, ${2:0px}, ${3:0px})"],
            ["translateX()", "translateX(${1:10px})"],
            ["translateY()", "translateY(${1:10px})"],
            ["translateZ()", "translateZ(${1:10px})"],
        ],
        "transform-box": [
            "border-box",
            "content-box",
            "fill-box",
            "stroke-box",
            "view-box",
        ],
        "transform-origin": ["<calc>", "<position>"],
        "transform-style": ["preserve-3d", "flat"],
        "transition": [
            "<calc>",
            "<timing>",
            "all",
            "none",
        ],
        "transition-behavior": [
            "normal",
            "allow-discrete",
        ],
        "transition-delay": [
            "<calc>",
        ],
        "transition-duration": [
            "<calc>",
        ],
        "transition-property": [
            "all",
            "none",
        ],
        "transition-timing-function": ["<calc>", "<timing>"],
        "translate": ["<calc>", "none"],
        "unicode-bidi": [
            "bidi-override",
            "embed",
            "isolate",
            "isolate-override",
            "normal",
            "plaintext",
        ],
        "unicode-range": [],
        "user-select": ["all", "auto", "text", "none"],
        "user-zoom": ["fixed", "zoom"],
        "vector-effect": [
            "none",
            "non-scaling-stroke",
            "non-scaling-size",
            "non-rotation",
            "fixed-position"
        ],
        "vertical-align": [
            "<calc>",
            "baseline",
            "sub",
            "super",
            "text-top",
            "text-bottom",
            "middle",
            "top",
            "bottom",
        ],
        "view-transition-name": ["none"],
        "view-transition-class": ["none"],
        "viewport-fit": ["auto", "contain", "cover"],
        "visibility": ["visible", "hidden", "collapse"],
        "white-space": [
            "normal",
            "pre",
            "pre-wrap",
            "pre-line",
            "<text-wrap-mode>",
            "<white-space-collapse>",
        ],
        "white-space-collapse": ["<white-space-collapse>"],
        "widows": [
            "<calc>",
        ],
        "width": ["<calc>", "auto", "fit-content"],
        "will-change": [
            "auto",
            "contents",
            "scroll-position",
        ],
        "word-break": [
            "normal",
            "break-all",
            "break-word",
            "keep-all",
            "auto-phrase",
        ],
        "word-spacing": [
            "<calc>",
            "normal",
        ],
        "word-wrap": ["normal", "break-word"],
        "writing-mode": [
            "horizontal-tb",
            "vertical-rl",
            "vertical-lr",
            "sideways-rl",
            "sideways-lr",
        ],
        "x": ["<calc>"],
        "y": ["<calc>"],
        "z-index": [
            "<calc>",
            "auto",
        ],
        "zoom": ["<calc>", "auto", "normal", "reset"],
    }


for_all = [
    'inherit',
    'initial',
    'revert',
    'revert-layer',
    'unset',
    'var()',
    '!important'
    ]


'''
# pre-process keys which have " | " separators
# in 2025.04, this is not needed anymore, no such keys with " | "
for k in props.copy(): # copy() is required
    if ' | ' in k:
        val = props[k]
        del props[k]
        for kk in k.split(' | '):
            props[kk] = val
'''


def resolve_data(r, val):
    if type(val) is str:
        if val.startswith('<') and val.endswith('>'):
            for m in common_values.get(val[1:-1], []):
                resolve_data(r, m)
        else:
            r.append(val)
    elif type(val) is list:
        r.append(val[0])
    else:
        print('ERROR: cudax_css.py value of unsupported type: '+str(val))


def get_data(name):
    #get list of properties
    if not name:
        return list(props.keys())

    #get list of values for property
    r = []
    values = props.get(name, [])
    if type(values) is not list:
        print('ERROR: cudax_css.py unsupported values: '+str(values))
        return []
    for val in values:
        resolve_data(r, val)
    r += for_all
    return r
