#ifdef VM_CODES

enum class vm_code : uint8_t {
   ref=0,
   _const=1,
   closure=2,
   call=3,
   call_receive_one=4,
   call_receive_fixed=5,
   bind=6,
   set=7,
   make_cell=8,
   cell_ref=9,
   cell_set=10,
   make_closure=11,
   make_uninitialized_closure=12,
   initialize_closure=13,
   _return=14,
   bind_required_args=15,
   bind_optional_args=16,
   listify_rest_args=17,
   vaslistify_rest_args=18,
   parse_key_args=19,
   jump_8=20,
   jump_16=21,
   jump_24=22,
   jump_if_8=23,
   jump_if_16=24,
   jump_if_24=25,
   jump_if_supplied_8=26,
   jump_if_supplied_16=27,
   check_arg_count_LE=28,
   check_arg_count_GE=29,
   check_arg_count_EQ=30,
   push_values=31,
   append_values=32,
   pop_values=33,
   mv_call=34,
   mv_call_receive_one=35,
   mv_call_receive_fixed=36,
   save_sp=37,
   restore_sp=38,
   entry=39,
   exit_8=40,
   exit_16=41,
   exit_24=42,
   entry_close=43,
   catch_8=44,
   catch_16=45,
   _throw=46,
   catch_close=47,
   special_bind=48,
   symbol_value=49,
   symbol_value_set=50,
   unbind=51,
   progv=52,
   fdefinition=53,
   nil=54,
   eq=55,
   push=56,
   pop=57,
   dup=58,
   fdesignator=59,
   called_fdefinition=60,
   protect=61,
   cleanup=62,
   encell=63,
   _long=255 };

#endif // VM_CODES
#ifdef PYTHON_OPCODES
R"opcodes(
new_instr( "ref", 0, [ 1], [ 2] )
new_instr( "const", 1, [ 9], [ 10] )
new_instr( "closure", 2, [ 1], [ 2] )
new_instr( "call", 3, [ 1], [ 2] )
new_instr( "call-receive-one", 4, [ 1], [ 2] )
new_instr( "call-receive-fixed", 5, [ 1,  1], [ 2,  2] )
new_instr( "bind", 6, [ 1,  1], [ 2,  2] )
new_instr( "set", 7, [ 1], [ 2] )
new_instr( "make-cell", 8, [], [] )
new_instr( "cell-ref", 9, [], [] )
new_instr( "cell-set", 10, [], [] )
new_instr( "make-closure", 11, [ 9], [ 10] )
new_instr( "make-uninitialized-closure", 12, [ 9], [ 10] )
new_instr( "initialize-closure", 13, [ 1], [ 2] )
new_instr( "return", 14, [], [] )
new_instr( "bind-required-args", 15, [ 1], [ 2] )
new_instr( "bind-optional-args", 16, [ 1,  1], [ 2,  2] )
new_instr( "listify-rest-args", 17, [ 1], [ 2] )
new_instr( "vaslistify-rest-args", 18, [ 1], [] )
new_instr( "parse-key-args", 19, [ 1,  1,  25], [ 2,  2,  26] )
new_instr( "jump-8", 20, [ 17], [] )
new_instr( "jump-16", 21, [ 18], [] )
new_instr( "jump-24", 22, [ 19], [] )
new_instr( "jump-if-8", 23, [ 17], [] )
new_instr( "jump-if-16", 24, [ 18], [] )
new_instr( "jump-if-24", 25, [ 19], [] )
new_instr( "jump-if-supplied-8", 26, [ 17], [] )
new_instr( "jump-if-supplied-16", 27, [ 18], [] )
new_instr( "check-arg-count-LE", 28, [ 1], [ 2] )
new_instr( "check-arg-count-GE", 29, [ 1], [ 2] )
new_instr( "check-arg-count-EQ", 30, [ 1], [ 2] )
new_instr( "push-values", 31, [], [] )
new_instr( "append-values", 32, [], [] )
new_instr( "pop-values", 33, [], [] )
new_instr( "mv-call", 34, [], [] )
new_instr( "mv-call-receive-one", 35, [], [] )
new_instr( "mv-call-receive-fixed", 36, [ 1], [ 2] )
new_instr( "save-sp", 37, [ 1], [ 2] )
new_instr( "restore-sp", 38, [ 1], [ 2] )
new_instr( "entry", 39, [ 1], [ 2] )
new_instr( "exit-8", 40, [ 17], [] )
new_instr( "exit-16", 41, [ 18], [] )
new_instr( "exit-24", 42, [ 19], [] )
new_instr( "entry-close", 43, [], [] )
new_instr( "catch-8", 44, [ 17], [] )
new_instr( "catch-16", 45, [ 18], [] )
new_instr( "throw", 46, [], [] )
new_instr( "catch-close", 47, [], [] )
new_instr( "special-bind", 48, [ 9], [ 10] )
new_instr( "symbol-value", 49, [ 9], [ 10] )
new_instr( "symbol-value-set", 50, [ 9], [ 10] )
new_instr( "unbind", 51, [], [] )
new_instr( "progv", 52, [ 9], [ 10] )
new_instr( "fdefinition", 53, [ 9], [ 10] )
new_instr( "nil", 54, [], [] )
new_instr( "eq", 55, [], [] )
new_instr( "push", 56, [], [] )
new_instr( "pop", 57, [], [] )
new_instr( "dup", 58, [], [] )
new_instr( "fdesignator", 59, [ 9], [ 10] )
new_instr( "called-fdefinition", 60, [ 9], [ 10] )
new_instr( "protect", 61, [ 9], [ 10] )
new_instr( "cleanup", 62, [], [] )
new_instr( "encell", 63, [ 1], [ 2] )
new_instr( "long", 255, [], [] )
)opcodes"
#endif
#ifdef GF_BYTECODE_VM
#define DTREE_OP_MISS 0

#define DTREE_OP_ADVANCE 1

#define DTREE_OP_TAG_TEST 2
#define DTREE_FIXNUM_TAG_OFFSET 1
#define DTREE_SINGLE_FLOAT_TAG_OFFSET 2
#define DTREE_CHARACTER_TAG_OFFSET 3
#define DTREE_CONS_TAG_OFFSET 4
#define DTREE_GENERAL_TAG_OFFSET 5

#define DTREE_OP_STAMP_READ 3
#define DTREE_READ_HEADER_OFFSET 1
#define DTREE_READ_OTHER_OFFSET 2

#define DTREE_OP_LT_BRANCH 4
#define DTREE_LT_PIVOT_OFFSET 1
#define DTREE_LT_LEFT_OFFSET 2
#define DTREE_LT_RIGHT_OFFSET 3

#define DTREE_OP_EQ_CHECK 5
#define DTREE_EQ_PIVOT_OFFSET 1
#define DTREE_EQ_NEXT_OFFSET 2

#define DTREE_OP_RANGE_CHECK 6
#define DTREE_RANGE_MIN_OFFSET 1
#define DTREE_RANGE_MAX_OFFSET 2
#define DTREE_RANGE_NEXT_OFFSET 3

#define DTREE_OP_EQL 7
#define DTREE_EQL_OBJECT_OFFSET 1
#define DTREE_EQL_BRANCH_OFFSET 2
#define DTREE_EQL_NEXT_OFFSET 3

#define DTREE_OP_SLOT_READ 8
#define DTREE_SLOT_READER_INDEX_OFFSET 1
#define DTREE_SLOT_READER_SLOT_NAME_OFFSET 2

#define DTREE_OP_SLOT_WRITE 9
#define DTREE_SLOT_WRITER_INDEX_OFFSET 1

#define DTREE_OP_CAR 10
#define DTREE_CAR_READER_INDEX_OFFSET 1
#define DTREE_CAR_READER_CAR_NAME_OFFSET 2

#define DTREE_OP_RPLACA 11
#define DTREE_RPLACA_WRITER_INDEX_OFFSET 1

#define DTREE_OP_EFFECTIVE_METHOD 12
#define DTREE_EFFECTIVE_METHOD_OFFSET 1

#define DTREE_OP_FARG0 13

#define DTREE_OP_FARG1 14

#define DTREE_OP_FARG2 15

#define DTREE_OP_FARG3 16

#define DTREE_OP_FARG4 17

#define DTREE_OP_ARGN 18
#define DTREE_ARGN_OFFSET 1
#define DTREE_ARGN_NEXT_OFFSET 2

#define DTREE_OP_SD_EQ_BRANCH 19
#define DTREE_SD_STAMP_OFFSET 1
#define DTREE_SD_FAIL_OFFSET 2
#define DTREE_SD_NEXT_OFFSET 3

#define DTREE_OP_SINGLE_DISPATCH_MISS 20

#define DTREE_OP_COUNT 21
#endif // GF_BYTECODE_VM
#ifdef GF_BYTECODE_VM_NAMES
  case DTREE_OP_MISS: return "DTREE_OP_MISS";
  case DTREE_OP_ADVANCE: return "DTREE_OP_ADVANCE";
  case DTREE_OP_TAG_TEST: return "DTREE_OP_TAG_TEST";
  case DTREE_OP_STAMP_READ: return "DTREE_OP_STAMP_READ";
  case DTREE_OP_LT_BRANCH: return "DTREE_OP_LT_BRANCH";
  case DTREE_OP_EQ_CHECK: return "DTREE_OP_EQ_CHECK";
  case DTREE_OP_RANGE_CHECK: return "DTREE_OP_RANGE_CHECK";
  case DTREE_OP_EQL: return "DTREE_OP_EQL";
  case DTREE_OP_SLOT_READ: return "DTREE_OP_SLOT_READ";
  case DTREE_OP_SLOT_WRITE: return "DTREE_OP_SLOT_WRITE";
  case DTREE_OP_CAR: return "DTREE_OP_CAR";
  case DTREE_OP_RPLACA: return "DTREE_OP_RPLACA";
  case DTREE_OP_EFFECTIVE_METHOD: return "DTREE_OP_EFFECTIVE_METHOD";
  case DTREE_OP_FARG0: return "DTREE_OP_FARG0";
  case DTREE_OP_FARG1: return "DTREE_OP_FARG1";
  case DTREE_OP_FARG2: return "DTREE_OP_FARG2";
  case DTREE_OP_FARG3: return "DTREE_OP_FARG3";
  case DTREE_OP_FARG4: return "DTREE_OP_FARG4";
  case DTREE_OP_ARGN: return "DTREE_OP_ARGN";
  case DTREE_OP_SD_EQ_BRANCH: return "DTREE_OP_SD_EQ_BRANCH";
  case DTREE_OP_SINGLE_DISPATCH_MISS: return "DTREE_OP_SINGLE_DISPATCH_MISS";
#endif // GF_BYTECODE_VM_NAMES
// This is where I dump the python GF bytecode VM
#ifdef DEFINE_LTV_PARSERS
void parse_ltvc_make_nil(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_nil\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  ltvc_make_nil( roots, tag, index);
};
void parse_ltvc_make_t(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_t\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  ltvc_make_t( roots, tag, index);
};
void parse_ltvc_make_ratio(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_ratio\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg3 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_make_ratio( roots, tag, index, arg2, arg3);
};
void parse_ltvc_make_complex(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_complex\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg3 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_make_complex( roots, tag, index, arg2, arg3);
};
void parse_ltvc_make_cons(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_cons\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  ltvc_make_cons( roots, tag, index);
};
void parse_ltvc_rplaca(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_rplaca\n", __FILE__, __LINE__, __FUNCTION__);
  T_O* arg0 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg1 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_rplaca( roots, arg0, arg1);
};
void parse_ltvc_rplacd(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_rplacd\n", __FILE__, __LINE__, __FUNCTION__);
  T_O* arg0 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg1 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_rplacd( roots, arg0, arg1);
};
void parse_ltvc_make_list(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_list\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  size_t arg2 = ltvc_read_size_t( bytecode, byteend, log );
  ltvc_make_list( roots, tag, index, arg2);
};
void parse_ltvc_fill_list(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_fill_list\n", __FILE__, __LINE__, __FUNCTION__);
  T_O* arg0 = ltvc_read_object(roots,  bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  Cons_O* varargs = ltvc_read_list( roots, index, bytecode, byteend, log );
  ltvc_fill_list_varargs( roots, arg0, index, varargs);
};
void parse_ltvc_make_array(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_array\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg3 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_make_array( roots, tag, index, arg2, arg3);
};
void parse_ltvc_setf_row_major_aref(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_setf_row_major_aref\n", __FILE__, __LINE__, __FUNCTION__);
  T_O* arg0 = ltvc_read_object(roots,  bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_setf_row_major_aref( roots, arg0, index, arg2);
};
void parse_ltvc_make_hash_table(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_hash_table\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_make_hash_table( roots, tag, index, arg2);
};
void parse_ltvc_setf_gethash(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_setf_gethash\n", __FILE__, __LINE__, __FUNCTION__);
  T_O* arg0 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg1 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_setf_gethash( roots, arg0, arg1, arg2);
};
void parse_ltvc_make_fixnum(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_fixnum\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  uintptr_t arg2 = ltvc_read_size_t( bytecode, byteend, log );
  ltvc_make_fixnum( roots, tag, index, arg2);
};
void parse_ltvc_make_package(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_package\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_make_package( roots, tag, index, arg2);
};
void parse_ltvc_make_next_bignum(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_next_bignum\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_bignum( bytecode, byteend, log );
  ltvc_make_next_bignum( roots, tag, index, arg2);
};
void parse_ltvc_make_bitvector(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_bitvector\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_make_bitvector( roots, tag, index, arg2);
};
void parse_ltvc_make_symbol(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_symbol\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg3 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_make_symbol( roots, tag, index, arg2, arg3);
};
void parse_ltvc_make_character(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_character\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  uintptr_t arg2 = ltvc_read_size_t( bytecode, byteend, log );
  ltvc_make_character( roots, tag, index, arg2);
};
void parse_ltvc_make_base_string(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_base_string\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  string arg2 = ltvc_read_string( bytecode, byteend, log );
  ltvc_make_base_string( roots, tag, index, arg2.c_str());
};
void parse_ltvc_make_pathname(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_pathname\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg3 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg4 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg5 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg6 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg7 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_make_pathname( roots, tag, index, arg2, arg3, arg4, arg5, arg6, arg7);
};
void parse_ltvc_make_function_description(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_function_description\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg3 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg4 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg5 = ltvc_read_object(roots,  bytecode, byteend, log );
  T_O* arg6 = ltvc_read_object(roots,  bytecode, byteend, log );
  size_t arg7 = ltvc_read_size_t( bytecode, byteend, log );
  size_t arg8 = ltvc_read_size_t( bytecode, byteend, log );
  size_t arg9 = ltvc_read_size_t( bytecode, byteend, log );
  ltvc_make_function_description( roots, tag, index, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
};
void parse_ltvc_make_global_entry_point(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_global_entry_point\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  size_t arg2 = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg3 = ltvc_read_object(roots,  bytecode, byteend, log );
  size_t arg4 = ltvc_read_size_t( bytecode, byteend, log );
  ltvc_make_global_entry_point( roots, tag, index, arg2, arg3, arg4);
};
void parse_ltvc_make_local_entry_point(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_local_entry_point\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  size_t arg2 = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg3 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_make_local_entry_point( roots, tag, index, arg2, arg3);
};
void parse_ltvc_ensure_fcell(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_ensure_fcell\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_ensure_fcell( roots, tag, index, arg2);
};
void parse_ltvc_ensure_vcell(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_ensure_vcell\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_ensure_vcell( roots, tag, index, arg2);
};
void parse_ltvc_make_random_state(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_random_state\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  ltvc_make_random_state( roots, tag, index, arg2);
};
void parse_ltvc_make_binary32(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_binary32\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  float arg2 = ltvc_read_float( bytecode, byteend, log );
  ltvc_make_binary32( roots, tag, index, arg2);
};
void parse_ltvc_make_binary64(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_binary64\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  double arg2 = ltvc_read_double( bytecode, byteend, log );
  ltvc_make_binary64( roots, tag, index, arg2);
};
void parse_ltvc_make_binary80(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_binary80\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  long_float_t arg2 = ltvc_read_binary80( bytecode, byteend, log );
  ltvc_make_binary80( roots, tag, index, arg2);
};
void parse_ltvc_set_mlf_creator_funcall(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_set_mlf_creator_funcall\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  size_t arg2 = ltvc_read_size_t( bytecode, byteend, log );
  string arg3 = ltvc_read_string( bytecode, byteend, log );
  ltvc_set_mlf_creator_funcall( roots, tag, index, arg2, arg3.c_str());
};
void parse_ltvc_mlf_init_funcall(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_mlf_init_funcall\n", __FILE__, __LINE__, __FUNCTION__);
  size_t arg0 = ltvc_read_size_t( bytecode, byteend, log );
  string arg1 = ltvc_read_string( bytecode, byteend, log );
  ltvc_mlf_init_funcall( roots, arg0, arg1.c_str());
};
void parse_ltvc_mlf_init_basic_call(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_mlf_init_basic_call\n", __FILE__, __LINE__, __FUNCTION__);
  T_O* arg0 = ltvc_read_object(roots,  bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  Cons_O* varargs = ltvc_read_list( roots, index, bytecode, byteend, log );
  ltvc_mlf_init_basic_call_varargs( roots, arg0, index, varargs);
};
void parse_ltvc_mlf_create_basic_call(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_mlf_create_basic_call\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  T_O* arg2 = ltvc_read_object(roots,  bytecode, byteend, log );
  size_t arg3 = ltvc_read_size_t( bytecode, byteend, log );
  Cons_O* varargs = ltvc_read_list( roots, arg3, bytecode, byteend, log );
  ltvc_mlf_create_basic_call_varargs( roots, tag, index, arg2, arg3, varargs);
};
void parse_ltvc_set_ltv_funcall(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_set_ltv_funcall\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  size_t arg2 = ltvc_read_size_t( bytecode, byteend, log );
  string arg3 = ltvc_read_string( bytecode, byteend, log );
  ltvc_set_ltv_funcall( roots, tag, index, arg2, arg3.c_str());
};
void parse_ltvc_toplevel_funcall(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_toplevel_funcall\n", __FILE__, __LINE__, __FUNCTION__);
  size_t arg0 = ltvc_read_size_t( bytecode, byteend, log );
  string arg1 = ltvc_read_string( bytecode, byteend, log );
  ltvc_toplevel_funcall( roots, arg0, arg1.c_str());
};
void parse_ltvc_make_binary16(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_binary16\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  short_float_t arg2 = ltvc_read_binary16( bytecode, byteend, log );
  ltvc_make_binary16( roots, tag, index, arg2);
};
void parse_ltvc_make_binary128(gctools::GCRootsInModule* roots, char*& bytecode, char* byteend, bool log) {
  if (log) printf("%s:%d:%s parse_ltvc_make_binary128\n", __FILE__, __LINE__, __FUNCTION__);
  char tag = ltvc_read_char( bytecode, byteend, log );
  size_t index = ltvc_read_size_t( bytecode, byteend, log );
  long_float_t arg2 = ltvc_read_binary128( bytecode, byteend, log );
  ltvc_make_binary128( roots, tag, index, arg2);
};
#endif // DEFINE_LTV_PARSERS
#ifdef DEFINE_LTV_SWITCH
  case 65:
    parse_ltvc_make_nil(roots, bytecode, byteend, log);
    break;
  case 66:
    parse_ltvc_make_t(roots, bytecode, byteend, log);
    break;
  case 67:
    parse_ltvc_make_ratio(roots, bytecode, byteend, log);
    break;
  case 68:
    parse_ltvc_make_complex(roots, bytecode, byteend, log);
    break;
  case 69:
    parse_ltvc_make_cons(roots, bytecode, byteend, log);
    break;
  case 70:
    parse_ltvc_rplaca(roots, bytecode, byteend, log);
    break;
  case 71:
    parse_ltvc_rplacd(roots, bytecode, byteend, log);
    break;
  case 72:
    parse_ltvc_make_list(roots, bytecode, byteend, log);
    break;
  case 73:
    parse_ltvc_fill_list(roots, bytecode, byteend, log);
    break;
  case 74:
    parse_ltvc_make_array(roots, bytecode, byteend, log);
    break;
  case 75:
    parse_ltvc_setf_row_major_aref(roots, bytecode, byteend, log);
    break;
  case 76:
    parse_ltvc_make_hash_table(roots, bytecode, byteend, log);
    break;
  case 77:
    parse_ltvc_setf_gethash(roots, bytecode, byteend, log);
    break;
  case 78:
    parse_ltvc_make_fixnum(roots, bytecode, byteend, log);
    break;
  case 79:
    parse_ltvc_make_package(roots, bytecode, byteend, log);
    break;
  case 80:
    parse_ltvc_make_next_bignum(roots, bytecode, byteend, log);
    break;
  case 81:
    parse_ltvc_make_bitvector(roots, bytecode, byteend, log);
    break;
  case 82:
    parse_ltvc_make_symbol(roots, bytecode, byteend, log);
    break;
  case 83:
    parse_ltvc_make_character(roots, bytecode, byteend, log);
    break;
  case 84:
    parse_ltvc_make_base_string(roots, bytecode, byteend, log);
    break;
  case 85:
    parse_ltvc_make_pathname(roots, bytecode, byteend, log);
    break;
  case 86:
    parse_ltvc_make_function_description(roots, bytecode, byteend, log);
    break;
  case 87:
    parse_ltvc_make_global_entry_point(roots, bytecode, byteend, log);
    break;
  case 88:
    parse_ltvc_make_local_entry_point(roots, bytecode, byteend, log);
    break;
  case 89:
    parse_ltvc_ensure_fcell(roots, bytecode, byteend, log);
    break;
  case 90:
    parse_ltvc_ensure_vcell(roots, bytecode, byteend, log);
    break;
  case 91:
    parse_ltvc_make_random_state(roots, bytecode, byteend, log);
    break;
  case 92:
    parse_ltvc_make_binary32(roots, bytecode, byteend, log);
    break;
  case 93:
    parse_ltvc_make_binary64(roots, bytecode, byteend, log);
    break;
  case 94:
    parse_ltvc_make_binary80(roots, bytecode, byteend, log);
    break;
  case 95:
    parse_ltvc_set_mlf_creator_funcall(roots, bytecode, byteend, log);
    break;
  case 96:
    parse_ltvc_mlf_init_funcall(roots, bytecode, byteend, log);
    break;
  case 97:
    parse_ltvc_mlf_init_basic_call(roots, bytecode, byteend, log);
    break;
  case 98:
    parse_ltvc_mlf_create_basic_call(roots, bytecode, byteend, log);
    break;
  case 99:
    parse_ltvc_set_ltv_funcall(roots, bytecode, byteend, log);
    break;
  case 100:
    parse_ltvc_toplevel_funcall(roots, bytecode, byteend, log);
    break;
  case 102:
    parse_ltvc_make_binary16(roots, bytecode, byteend, log);
    break;
  case 103:
    parse_ltvc_make_binary128(roots, bytecode, byteend, log);
    break;
#endif // DEFINE_LTV_SWITCH

#ifdef DEFINE_BYTECODE_LTV_OPS
enum class bytecode_ltv : uint8_t {
  nil = 65,
  t = 66,
  ratio = 67,
  complex = 68,
  cons = 69,
  init_cons = 70,
  base_string = 72,
  utf8_string = 73,
  make_array = 74,
  init_array = 75,
  make_hash_table = 76,
  init_hash_table = 77,
  make_sb64 = 78,
  find_package = 79,
  make_bignum = 80,
  make_symbol = 81,
  intern = 82,
  make_character = 83,
  make_pathname = 85,
  make_bytecode_function = 87,
  make_bytecode_module = 88,
  setf_literals = 89,
  make_binary32 = 90,
  make_binary64 = 91,
  make_binary80 = 92,
  funcall_create = 93,
  funcall_initialize = 94,
  fdefinition = 95,
  fcell = 96,
  vcell = 97,
  find_class = 98,
  init_object_array = 99,
  environment = 100,
  symbol_value = 101,
  make_binary16 = 102,
  make_binary128 = 103,
  attribute = 255,
};
enum class bytecode_uaet : uint8_t {
  nil = 0,
  t = 1,
  base_char = 32,
  character = 33,
  binary16 = 64,
  binary32 = 65,
  binary64 = 66,
  binary80 = 67,
  binary128 = 71,
  complex_binary16 = 96,
  complex_binary32 = 97,
  complex_binary64 = 98,
  complex_binary80 = 99,
  complex_binary128 = 100,
  unsigned_byte1 = 128,
  unsigned_byte2 = 129,
  unsigned_byte4 = 130,
  unsigned_byte8 = 131,
  unsigned_byte16 = 132,
  unsigned_byte32 = 133,
  unsigned_byte64 = 134,
  unsigned_byte128 = 135,
  signed_byte8 = 163,
  signed_byte16 = 164,
  signed_byte32 = 165,
  signed_byte64 = 166,
  signed_byte128 = 167,
};
enum class bytecode_debug_info : uint8_t {
  function = 0,
  vars = 1,
  location = 2,
  decls = 3,
  the = 4,
  block = 5,
  exit = 6,
  macro = 7,
  _if = 8,
  tagbody = 9,
};
#endif
