(in-package #:cleavir-reaching-definitions)

(cleavir-flow:define-flow reaching-definitions (:direction :forward)
  ((before :accessor before :reader reaching :initform (make-hash-table))))

(defmethod cleavir-flow:flow ((flow reaching-definitions) graph node)
  (cleavir-graph:with-graph (graph)
    (let ((before (before node flow)))
      (cleavir-graph:do-successors (succ node)
        (let ((sbefore (before succ flow)) (changep nil))
          (cleavir-graph:do-outputs (out node)
            (unless (gethash out sbefore)
              (setf (gethash out sbefore) node changep t)))
          (maphash (lambda (out definer)
                     (unless (gethash out sbefore)
                       (setf (gethash out sbefore) definer changep t)))
                   before)
          (when changep (cleavir-flow:mark flow succ)))))))
