/*
    File: sharpEqualWrapper.cc
*/

/*
Copyright (c) 2014, Christian E. Schafmeister

CLASP is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

See directory 'clasp/licenses' for full details.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
/* -^- */
// #define DEBUG_LEVEL_FULL

#include <string.h>
#include <clasp/core/foundation.h>
#include <clasp/core/common.h>
#include <clasp/core/hashTableEqual.h>
#include <clasp/core/symbolTable.h>
#include <clasp/core/lambdaListHandler.h>
#include <clasp/core/multipleValues.h>
#include <clasp/core/evaluator.h>
// #i n c l u d e "render.h"
#include <clasp/core/hashTableEq.h>
#include <clasp/core/wrappers.h>
#include <clasp/core/sharpEqualWrapper.h>

namespace core {

string SharpEqualWrapper_O::__repr__() const {
  stringstream ss;
  ss << "#<SHARP-EQUAL-WRAPPER " << _rep_(this->_Label) << ">";
  return ss.str();
}

CL_NAME("SHARP-EQUAL-WRAPPER-VALUE");
DOCGROUP(clasp);
CL_DEFUN_SETF T_sp core__setf_sharp_equal_wrapper_value(T_sp value, SharpEqualWrapper_sp wrapper) {
  wrapper->set_sharp_equal_wrapper_value(value);
  return value;
}

}; // namespace core
