# SPDX-FileCopyrightText: © 2023 Christian BUHTZ <c.buhtz@posteo.jp>
#
# SPDX-License-Identifier: GPL-2.0-or-later
#
# This file is part of the program "Back In Time" which is released under GNU
# General Public License v2 (GPLv2). See LICENSES directory or go to
# <https://spdx.org/licenses/GPL-2.0-or-later.html>.
#
# Generated at Mon Nov 10 15:02:27 2025 with help
# of package "babel" and "polib".
# https://babel.pocoo.org
# https://github.com/python-babel/babel
# pylint: disable=too-many-lines,missing-module-docstring
names = {
    'ar': {
        '_native': 'العربية',
        'ar': 'العربية',
        'bg': 'арабски',
        'bs': 'arapski',
        'ca': 'àrab',
        'cs': 'arabština',
        'da': 'arabisk',
        'de': 'Arabisch',
        'el': 'Αραβικά',
        'en': 'Arabic',
        'eo': 'araba',
        'es': 'árabe',
        'et': 'araabia',
        'eu': 'arabiera',
        'fa': 'عربی',
        'fi': 'arabia',
        'fo': 'arabiskt',
        'fr': 'arabe',
        'gl': 'árabe',
        'he': 'ערבית',
        'hr': 'arapski',
        'hu': 'arab',
        'id': 'Arab',
        'ie': 'arabic',
        'is': 'arabíska',
        'it': 'arabo',
        'ja': 'アラビア語',
        'ko': '아랍어',
        'lt': 'arabų',
        'nb': 'arabisk',
        'nl': 'Arabisch',
        'nn': 'arabisk',
        'pl': 'arabski',
        'pt': 'árabe',
        'pt_BR': 'árabe',
        'ro': 'arabă',
        'ru': 'арабский',
        'sk': 'arabčina',
        'sl': 'arabščina',
        'sr': 'арапски',
        'sr_Latn': 'arapski',
        'sv': 'arabiska',
        'th': 'อาหรับ',
        'tr': 'Arapça',
        'uk': 'арабська',
        'vi': 'Tiếng Ả Rập',
        'zh_CN': '阿拉伯语',
        'zh_TW': '阿拉伯文',
    },
    'bg': {
        '_native': 'български',
        'ar': 'البلغارية',
        'bg': 'български',
        'bs': 'bugarski',
        'ca': 'búlgar',
        'cs': 'bulharština',
        'da': 'bulgarsk',
        'de': 'Bulgarisch',
        'el': 'Βουλγαρικά',
        'en': 'Bulgarian',
        'eo': 'bulgara',
        'es': 'búlgaro',
        'et': 'bulgaaria',
        'eu': 'bulgariera',
        'fa': 'بلغاری',
        'fi': 'bulgaria',
        'fo': 'bulgarskt',
        'fr': 'bulgare',
        'gl': 'búlgaro',
        'he': 'בולגרית',
        'hr': 'bugarski',
        'hu': 'bolgár',
        'id': 'Bulgaria',
        'ie': 'bulgarian',
        'is': 'búlgarska',
        'it': 'bulgaro',
        'ja': 'ブルガリア語',
        'ko': '불가리아어',
        'lt': 'bulgarų',
        'nb': 'bulgarsk',
        'nl': 'Bulgaars',
        'nn': 'bulgarsk',
        'pl': 'bułgarski',
        'pt': 'búlgaro',
        'pt_BR': 'búlgaro',
        'ro': 'bulgară',
        'ru': 'болгарский',
        'sk': 'bulharčina',
        'sl': 'bolgarščina',
        'sr': 'бугарски',
        'sr_Latn': 'bugarski',
        'sv': 'bulgariska',
        'th': 'บัลแกเรีย',
        'tr': 'Bulgarca',
        'uk': 'болгарська',
        'vi': 'Tiếng Bulgaria',
        'zh_CN': '保加利亚语',
        'zh_TW': '保加利亞文',
    },
    'bs': {
        '_native': 'bosanski',
        'ar': 'البوسنية',
        'bg': 'босненски',
        'bs': 'bosanski',
        'ca': 'bosnià',
        'cs': 'bosenština',
        'da': 'bosnisk',
        'de': 'Bosnisch',
        'el': 'Βοσνιακά',
        'en': 'Bosnian',
        'eo': 'bosna',
        'es': 'bosnio',
        'et': 'bosnia',
        'eu': 'bosniera',
        'fa': 'بوسنیایی',
        'fi': 'bosnia',
        'fo': 'bosniskt',
        'fr': 'bosniaque',
        'gl': 'bosníaco',
        'he': 'בוסנית',
        'hr': 'bosanski',
        'hu': 'bosnyák',
        'id': 'Bosnia',
        'ie': 'bosnian',
        'is': 'bosníska',
        'it': 'bosniaco',
        'ja': 'ボスニア語',
        'ko': '보스니아어',
        'lt': 'bosnių',
        'nb': 'bosnisk',
        'nl': 'Bosnisch',
        'nn': 'bosnisk',
        'pl': 'bośniacki',
        'pt': 'bósnio',
        'pt_BR': 'bósnio',
        'ro': 'bosniacă',
        'ru': 'боснийский',
        'sk': 'bosniačtina',
        'sl': 'bosanščina',
        'sr': 'босански',
        'sr_Latn': 'bosanski',
        'sv': 'bosniska',
        'th': 'บอสเนีย',
        'tr': 'Boşnakça',
        'uk': 'боснійська',
        'vi': 'Tiếng Bosnia',
        'zh_CN': '波斯尼亚语',
        'zh_TW': '波士尼亞文',
    },
    'ca': {
        '_native': 'català',
        'ar': 'الكتالانية',
        'bg': 'каталонски',
        'bs': 'katalonski',
        'ca': 'català',
        'cs': 'katalánština',
        'da': 'catalansk',
        'de': 'Katalanisch',
        'el': 'Καταλανικά',
        'en': 'Catalan',
        'eo': 'kataluna',
        'es': 'catalán',
        'et': 'katalaani',
        'eu': 'katalana',
        'fa': 'کاتالان',
        'fi': 'katalaani',
        'fo': 'katalani',
        'fr': 'catalan',
        'gl': 'catalán',
        'he': 'קטלאנית',
        'hr': 'katalonski',
        'hu': 'katalán',
        'id': 'Katalan',
        'ie': 'catalan',
        'is': 'katalónska',
        'it': 'catalano',
        'ja': 'カタロニア語',
        'ko': '카탈로니아어',
        'lt': 'katalonų',
        'nb': 'katalansk',
        'nl': 'Catalaans',
        'nn': 'katalansk',
        'pl': 'kataloński',
        'pt': 'catalão',
        'pt_BR': 'catalão',
        'ro': 'catalană',
        'ru': 'каталанский',
        'sk': 'katalánčina',
        'sl': 'katalonščina',
        'sr': 'каталонски',
        'sr_Latn': 'katalonski',
        'sv': 'katalanska',
        'th': 'คาตาลัน',
        'tr': 'Katalanca',
        'uk': 'каталонська',
        'vi': 'Tiếng Catalan',
        'zh_CN': '加泰罗尼亚语',
        'zh_TW': '加泰蘭文',
    },
    'cs': {
        '_native': 'čeština',
        'ar': 'التشيكية',
        'bg': 'чешки',
        'bs': 'češki',
        'ca': 'txec',
        'cs': 'čeština',
        'da': 'tjekkisk',
        'de': 'Tschechisch',
        'el': 'Τσεχικά',
        'en': 'Czech',
        'eo': 'ĉeĥa',
        'es': 'checo',
        'et': 'tšehhi',
        'eu': 'txekiera',
        'fa': 'چکی',
        'fi': 'tšekki',
        'fo': 'kekkiskt',
        'fr': 'tchèque',
        'gl': 'checo',
        'he': 'צ׳כית',
        'hr': 'češki',
        'hu': 'cseh',
        'id': 'Cheska',
        'ie': 'tchec',
        'is': 'tékkneska',
        'it': 'ceco',
        'ja': 'チェコ語',
        'ko': '체코어',
        'lt': 'čekų',
        'nb': 'tsjekkisk',
        'nl': 'Tsjechisch',
        'nn': 'tsjekkisk',
        'pl': 'czeski',
        'pt': 'tcheco',
        'pt_BR': 'tcheco',
        'ro': 'cehă',
        'ru': 'чешский',
        'sk': 'čeština',
        'sl': 'češčina',
        'sr': 'чешки',
        'sr_Latn': 'češki',
        'sv': 'tjeckiska',
        'th': 'เช็ก',
        'tr': 'Çekçe',
        'uk': 'чеська',
        'vi': 'Tiếng Séc',
        'zh_CN': '捷克语',
        'zh_TW': '捷克文',
    },
    'da': {
        '_native': 'dansk',
        'ar': 'الدانمركية',
        'bg': 'датски',
        'bs': 'danski',
        'ca': 'danès',
        'cs': 'dánština',
        'da': 'dansk',
        'de': 'Dänisch',
        'el': 'Δανικά',
        'en': 'Danish',
        'eo': 'dana',
        'es': 'danés',
        'et': 'taani',
        'eu': 'daniera',
        'fa': 'دانمارکی',
        'fi': 'tanska',
        'fo': 'danskt',
        'fr': 'danois',
        'gl': 'dinamarqués',
        'he': 'דנית',
        'hr': 'danski',
        'hu': 'dán',
        'id': 'Dansk',
        'ie': 'danesi',
        'is': 'danska',
        'it': 'danese',
        'ja': 'デンマーク語',
        'ko': '덴마크어',
        'lt': 'danų',
        'nb': 'dansk',
        'nl': 'Deens',
        'nn': 'dansk',
        'pl': 'duński',
        'pt': 'dinamarquês',
        'pt_BR': 'dinamarquês',
        'ro': 'daneză',
        'ru': 'датский',
        'sk': 'dánčina',
        'sl': 'danščina',
        'sr': 'дански',
        'sr_Latn': 'danski',
        'sv': 'danska',
        'th': 'เดนมาร์ก',
        'tr': 'Danca',
        'uk': 'данська',
        'vi': 'Tiếng Đan Mạch',
        'zh_CN': '丹麦语',
        'zh_TW': '丹麥文',
    },
    'de': {
        '_native': 'Deutsch',
        'ar': 'الألمانية',
        'bg': 'немски',
        'bs': 'njemački',
        'ca': 'alemany',
        'cs': 'němčina',
        'da': 'tysk',
        'de': 'Deutsch',
        'el': 'Γερμανικά',
        'en': 'German',
        'eo': 'germana',
        'es': 'alemán',
        'et': 'saksa',
        'eu': 'alemana',
        'fa': 'آلمانی',
        'fi': 'saksa',
        'fo': 'týskt',
        'fr': 'allemand',
        'gl': 'alemán',
        'he': 'גרמנית',
        'hr': 'njemački',
        'hu': 'német',
        'id': 'Jerman',
        'ie': 'german',
        'is': 'þýska',
        'it': 'tedesco',
        'ja': 'ドイツ語',
        'ko': '독일어',
        'lt': 'vokiečių',
        'nb': 'tysk',
        'nl': 'Duits',
        'nn': 'tysk',
        'pl': 'niemiecki',
        'pt': 'alemão',
        'pt_BR': 'alemão',
        'ro': 'germană',
        'ru': 'немецкий',
        'sk': 'nemčina',
        'sl': 'nemščina',
        'sr': 'немачки',
        'sr_Latn': 'nemački',
        'sv': 'tyska',
        'th': 'เยอรมัน',
        'tr': 'Almanca',
        'uk': 'німецька',
        'vi': 'Tiếng Đức',
        'zh_CN': '德语',
        'zh_TW': '德文',
    },
    'el': {
        '_native': 'Ελληνικά',
        'ar': 'اليونانية',
        'bg': 'гръцки',
        'bs': 'grčki',
        'ca': 'grec',
        'cs': 'řečtina',
        'da': 'græsk',
        'de': 'Griechisch',
        'el': 'Ελληνικά',
        'en': 'Greek',
        'eo': 'greka',
        'es': 'griego',
        'et': 'kreeka',
        'eu': 'greziera',
        'fa': 'یونانی',
        'fi': 'kreikka',
        'fo': 'grikskt',
        'fr': 'grec',
        'gl': 'grego',
        'he': 'יוונית',
        'hr': 'grčki',
        'hu': 'görög',
        'id': 'Yunani',
        'ie': 'grec',
        'is': 'gríska',
        'it': 'greco',
        'ja': 'ギリシャ語',
        'ko': '그리스어',
        'lt': 'graikų',
        'nb': 'gresk',
        'nl': 'Grieks',
        'nn': 'gresk',
        'pl': 'grecki',
        'pt': 'grego',
        'pt_BR': 'grego',
        'ro': 'greacă',
        'ru': 'греческий',
        'sk': 'gréčtina',
        'sl': 'grščina',
        'sr': 'грчки',
        'sr_Latn': 'grčki',
        'sv': 'grekiska',
        'th': 'กรีก',
        'tr': 'Yunanca',
        'uk': 'грецька',
        'vi': 'Tiếng Hy Lạp',
        'zh_CN': '希腊语',
        'zh_TW': '希臘文',
    },
    'en': {
        '_native': 'English',
        'ar': 'الإنجليزية',
        'bg': 'английски',
        'bs': 'engleski',
        'ca': 'anglès',
        'cs': 'angličtina',
        'da': 'engelsk',
        'de': 'Englisch',
        'el': 'Αγγλικά',
        'en': 'English',
        'eo': 'angla',
        'es': 'inglés',
        'et': 'inglise',
        'eu': 'ingelesa',
        'fa': 'انگلیسی',
        'fi': 'englanti',
        'fo': 'enskt',
        'fr': 'anglais',
        'gl': 'inglés',
        'he': 'אנגלית',
        'hr': 'engleski',
        'hu': 'angol',
        'id': 'Inggris',
        'ie': 'anglesi',
        'is': 'enska',
        'it': 'inglese',
        'ja': '英語',
        'ko': '영어',
        'lt': 'anglų',
        'nb': 'engelsk',
        'nl': 'Engels',
        'nn': 'engelsk',
        'pl': 'angielski',
        'pt': 'inglês',
        'pt_BR': 'inglês',
        'ro': 'engleză',
        'ru': 'английский',
        'sk': 'angličtina',
        'sl': 'angleščina',
        'sr': 'енглески',
        'sr_Latn': 'engleski',
        'sv': 'engelska',
        'th': 'อังกฤษ',
        'tr': 'İngilizce',
        'uk': 'англійська',
        'vi': 'Tiếng Anh',
        'zh_CN': '英语',
        'zh_TW': '英文',
    },
    'eo': {
        '_native': 'Esperanto',
        'ar': 'الإسبرانتو',
        'bg': 'есперанто',
        'bs': 'esperanto',
        'ca': 'esperanto',
        'cs': 'esperanto',
        'da': 'esperanto',
        'de': 'Esperanto',
        'el': 'Εσπεράντο',
        'en': 'Esperanto',
        'eo': 'Esperanto',
        'es': 'esperanto',
        'et': 'esperanto',
        'eu': 'esperantoa',
        'fa': 'اسپرانتو',
        'fi': 'esperanto',
        'fo': 'esperanto',
        'fr': 'espéranto',
        'gl': 'esperanto',
        'he': 'אספרנטו',
        'hr': 'esperanto',
        'hu': 'eszperantó',
        'id': 'Esperanto',
        'ie': 'Esperanto',
        'is': 'esperantó',
        'it': 'esperanto',
        'ja': 'エスペラント語',
        'ko': '에스페란토어',
        'lt': 'esperanto',
        'nb': 'esperanto',
        'nl': 'Esperanto',
        'nn': 'esperanto',
        'pl': 'esperanto',
        'pt': 'esperanto',
        'pt_BR': 'esperanto',
        'ro': 'esperanto',
        'ru': 'эсперанто',
        'sk': 'esperanto',
        'sl': 'esperanto',
        'sr': 'есперанто',
        'sr_Latn': 'esperanto',
        'sv': 'esperanto',
        'th': 'เอสเปรันโต',
        'tr': 'Esperanto',
        'uk': 'есперанто',
        'vi': 'Tiếng Quốc Tế Ngữ',
        'zh_CN': '世界语',
        'zh_TW': '世界文',
    },
    'es': {
        '_native': 'español',
        'ar': 'الإسبانية',
        'bg': 'испански',
        'bs': 'španski',
        'ca': 'espanyol',
        'cs': 'španělština',
        'da': 'spansk',
        'de': 'Spanisch',
        'el': 'Ισπανικά',
        'en': 'Spanish',
        'eo': 'hispana',
        'es': 'español',
        'et': 'hispaania',
        'eu': 'gaztelania',
        'fa': 'اسپانیایی',
        'fi': 'espanja',
        'fo': 'spanskt',
        'fr': 'espagnol',
        'gl': 'español',
        'he': 'ספרדית',
        'hr': 'španjolski',
        'hu': 'spanyol',
        'id': 'Spanyol',
        'ie': 'hispan',
        'is': 'spænska',
        'it': 'spagnolo',
        'ja': 'スペイン語',
        'ko': '스페인어',
        'lt': 'ispanų',
        'nb': 'spansk',
        'nl': 'Spaans',
        'nn': 'spansk',
        'pl': 'hiszpański',
        'pt': 'espanhol',
        'pt_BR': 'espanhol',
        'ro': 'spaniolă',
        'ru': 'испанский',
        'sk': 'španielčina',
        'sl': 'španščina',
        'sr': 'шпански',
        'sr_Latn': 'španski',
        'sv': 'spanska',
        'th': 'สเปน',
        'tr': 'İspanyolca',
        'uk': 'іспанська',
        'vi': 'Tiếng Tây Ban Nha',
        'zh_CN': '西班牙语',
        'zh_TW': '西班牙文',
    },
    'et': {
        '_native': 'eesti',
        'ar': 'الإستونية',
        'bg': 'естонски',
        'bs': 'estonski',
        'ca': 'estonià',
        'cs': 'estonština',
        'da': 'estisk',
        'de': 'Estnisch',
        'el': 'Εσθονικά',
        'en': 'Estonian',
        'eo': 'estona',
        'es': 'estonio',
        'et': 'eesti',
        'eu': 'estoniera',
        'fa': 'استونیایی',
        'fi': 'viro',
        'fo': 'estiskt',
        'fr': 'estonien',
        'gl': 'estoniano',
        'he': 'אסטונית',
        'hr': 'estonski',
        'hu': 'észt',
        'id': 'Esti',
        'ie': 'estonian',
        'is': 'eistneska',
        'it': 'estone',
        'ja': 'エストニア語',
        'ko': '에스토니아어',
        'lt': 'estų',
        'nb': 'estisk',
        'nl': 'Estisch',
        'nn': 'estisk',
        'pl': 'estoński',
        'pt': 'estoniano',
        'pt_BR': 'estoniano',
        'ro': 'estonă',
        'ru': 'эстонский',
        'sk': 'estónčina',
        'sl': 'estonščina',
        'sr': 'естонски',
        'sr_Latn': 'estonski',
        'sv': 'estniska',
        'th': 'เอสโตเนีย',
        'tr': 'Estonca',
        'uk': 'естонська',
        'vi': 'Tiếng Estonia',
        'zh_CN': '爱沙尼亚语',
        'zh_TW': '愛沙尼亞文',
    },
    'eu': {
        '_native': 'euskara',
        'ar': 'الباسكية',
        'bg': 'баски',
        'bs': 'baskijski',
        'ca': 'basc',
        'cs': 'baskičtina',
        'da': 'baskisk',
        'de': 'Baskisch',
        'el': 'Βασκικά',
        'en': 'Basque',
        'eo': 'eŭska',
        'es': 'euskera',
        'et': 'baski',
        'eu': 'euskara',
        'fa': 'باسکی',
        'fi': 'baski',
        'fo': 'baskiskt',
        'fr': 'basque',
        'gl': 'éuscaro',
        'he': 'בסקית',
        'hr': 'baskijski',
        'hu': 'baszk',
        'id': 'Basque',
        'ie': 'basc',
        'is': 'baskneska',
        'it': 'basco',
        'ja': 'バスク語',
        'ko': '바스크어',
        'lt': 'baskų',
        'nb': 'baskisk',
        'nl': 'Baskisch',
        'nn': 'baskisk',
        'pl': 'baskijski',
        'pt': 'basco',
        'pt_BR': 'basco',
        'ro': 'bască',
        'ru': 'баскский',
        'sk': 'baskičtina',
        'sl': 'baskovščina',
        'sr': 'баскијски',
        'sr_Latn': 'baskijski',
        'sv': 'baskiska',
        'th': 'บาสก์',
        'tr': 'Baskça',
        'uk': 'баскська',
        'vi': 'Tiếng Basque',
        'zh_CN': '巴斯克语',
        'zh_TW': '巴斯克文',
    },
    'fa': {
        '_native': 'فارسی',
        'ar': 'الفارسية',
        'bg': 'персийски',
        'bs': 'perzijski',
        'ca': 'persa',
        'cs': 'perština',
        'da': 'persisk',
        'de': 'Persisch',
        'el': 'Περσικά',
        'en': 'Persian',
        'eo': 'persa',
        'es': 'persa',
        'et': 'pärsia',
        'eu': 'persiera',
        'fa': 'فارسی',
        'fi': 'persia',
        'fo': 'persiskt',
        'fr': 'persan',
        'gl': 'persa',
        'he': 'פרסית',
        'hr': 'perzijski',
        'hu': 'perzsa',
        'id': 'Persia',
        'ie': 'persian',
        'is': 'persneska',
        'it': 'persiano',
        'ja': 'ペルシア語',
        'ko': '페르시아어',
        'lt': 'persų',
        'nb': 'persisk',
        'nl': 'Perzisch',
        'nn': 'persisk',
        'pl': 'perski',
        'pt': 'persa',
        'pt_BR': 'persa',
        'ro': 'persană',
        'ru': 'персидский',
        'sk': 'perzština',
        'sl': 'perzijščina',
        'sr': 'персијски',
        'sr_Latn': 'persijski',
        'sv': 'persiska',
        'th': 'เปอร์เซีย',
        'tr': 'Farsça',
        'uk': 'перська',
        'vi': 'Tiếng Ba Tư',
        'zh_CN': '波斯语',
        'zh_TW': '波斯文',
    },
    'fi': {
        '_native': 'suomi',
        'ar': 'الفنلندية',
        'bg': 'фински',
        'bs': 'finski',
        'ca': 'finès',
        'cs': 'finština',
        'da': 'finsk',
        'de': 'Finnisch',
        'el': 'Φινλανδικά',
        'en': 'Finnish',
        'eo': 'finna',
        'es': 'finés',
        'et': 'soome',
        'eu': 'finlandiera',
        'fa': 'فنلاندی',
        'fi': 'suomi',
        'fo': 'finskt',
        'fr': 'finnois',
        'gl': 'finés',
        'he': 'פינית',
        'hr': 'finski',
        'hu': 'finn',
        'id': 'Suomi',
        'ie': 'finn',
        'is': 'finnska',
        'it': 'finlandese',
        'ja': 'フィンランド語',
        'ko': '핀란드어',
        'lt': 'suomių',
        'nb': 'finsk',
        'nl': 'Fins',
        'nn': 'finsk',
        'pl': 'fiński',
        'pt': 'finlandês',
        'pt_BR': 'finlandês',
        'ro': 'finlandeză',
        'ru': 'финский',
        'sk': 'fínčina',
        'sl': 'finščina',
        'sr': 'фински',
        'sr_Latn': 'finski',
        'sv': 'finska',
        'th': 'ฟินแลนด์',
        'tr': 'Fince',
        'uk': 'фінська',
        'vi': 'Tiếng Phần Lan',
        'zh_CN': '芬兰语',
        'zh_TW': '芬蘭文',
    },
    'fo': {
        '_native': 'føroyskt',
        'ar': 'الفاروية',
        'bg': 'фарьорски',
        'bs': 'farski',
        'ca': 'feroès',
        'cs': 'faerština',
        'da': 'færøsk',
        'de': 'Färöisch',
        'el': 'Φεροϊκά',
        'en': 'Faroese',
        'eo': 'feroa',
        'es': 'feroés',
        'et': 'fääri',
        'eu': 'faroera',
        'fa': 'فارویی',
        'fi': 'fääri',
        'fo': 'føroyskt',
        'fr': 'féroïen',
        'gl': 'feroés',
        'he': 'פארואזית',
        'hr': 'ferojski',
        'hu': 'feröeri',
        'id': 'Faroe',
        'ie': 'feroesi',
        'is': 'færeyska',
        'it': 'faroese',
        'ja': 'フェロー語',
        'ko': '페로어',
        'lt': 'farerų',
        'nb': 'færøysk',
        'nl': 'Faeröers',
        'nn': 'færøysk',
        'pl': 'farerski',
        'pt': 'feroês',
        'pt_BR': 'feroês',
        'ro': 'feroeză',
        'ru': 'фарерский',
        'sk': 'faerčina',
        'sl': 'ferščina',
        'sr': 'фарски',
        'sr_Latn': 'farski',
        'sv': 'färöiska',
        'th': 'แฟโร',
        'tr': 'Faroe dili',
        'uk': 'фарерська',
        'vi': 'Tiếng Faroe',
        'zh_CN': '法罗语',
        'zh_TW': '法羅文',
    },
    'fr': {
        '_native': 'français',
        'ar': 'الفرنسية',
        'bg': 'френски',
        'bs': 'francuski',
        'ca': 'francès',
        'cs': 'francouzština',
        'da': 'fransk',
        'de': 'Französisch',
        'el': 'Γαλλικά',
        'en': 'French',
        'eo': 'franca',
        'es': 'francés',
        'et': 'prantsuse',
        'eu': 'frantsesa',
        'fa': 'فرانسوی',
        'fi': 'ranska',
        'fo': 'franskt',
        'fr': 'français',
        'gl': 'francés',
        'he': 'צרפתית',
        'hr': 'francuski',
        'hu': 'francia',
        'id': 'Prancis',
        'ie': 'francesi',
        'is': 'franska',
        'it': 'francese',
        'ja': 'フランス語',
        'ko': '프랑스어',
        'lt': 'prancūzų',
        'nb': 'fransk',
        'nl': 'Frans',
        'nn': 'fransk',
        'pl': 'francuski',
        'pt': 'francês',
        'pt_BR': 'francês',
        'ro': 'franceză',
        'ru': 'французский',
        'sk': 'francúzština',
        'sl': 'francoščina',
        'sr': 'француски',
        'sr_Latn': 'francuski',
        'sv': 'franska',
        'th': 'ฝรั่งเศส',
        'tr': 'Fransızca',
        'uk': 'французька',
        'vi': 'Tiếng Pháp',
        'zh_CN': '法语',
        'zh_TW': '法文',
    },
    'gl': {
        '_native': 'galego',
        'ar': 'الجاليكية',
        'bg': 'галисийски',
        'bs': 'galicijski',
        'ca': 'gallec',
        'cs': 'galicijština',
        'da': 'galicisk',
        'de': 'Galicisch',
        'el': 'Γαλικιανά',
        'en': 'Galician',
        'eo': 'galega',
        'es': 'gallego',
        'et': 'galeegi',
        'eu': 'galiziera',
        'fa': 'گالیسیایی',
        'fi': 'galicia',
        'fo': 'galisiskt',
        'fr': 'galicien',
        'gl': 'galego',
        'he': 'גליציאנית',
        'hr': 'galicijski',
        'hu': 'gallego',
        'id': 'Galisia',
        'ie': 'galician',
        'is': 'galisíska',
        'it': 'galiziano',
        'ja': 'ガリシア語',
        'ko': '갈리시아어',
        'lt': 'galisų',
        'nb': 'galisisk',
        'nl': 'Galicisch',
        'nn': 'galisisk',
        'pl': 'galicyjski',
        'pt': 'galego',
        'pt_BR': 'galego',
        'ro': 'galiciană',
        'ru': 'галисийский',
        'sk': 'galícijčina',
        'sl': 'galicijščina',
        'sr': 'галицијски',
        'sr_Latn': 'galicijski',
        'sv': 'galiciska',
        'th': 'กาลิเซีย',
        'tr': 'Galiçyaca',
        'uk': 'галісійська',
        'vi': 'Tiếng Galician',
        'zh_CN': '加利西亚语',
        'zh_TW': '加利西亞文',
    },
    'he': {
        '_native': 'עברית',
        'ar': 'العبرية',
        'bg': 'иврит',
        'bs': 'hebrejski',
        'ca': 'hebreu',
        'cs': 'hebrejština',
        'da': 'hebraisk',
        'de': 'Hebräisch',
        'el': 'Εβραϊκά',
        'en': 'Hebrew',
        'eo': 'hebrea',
        'es': 'hebreo',
        'et': 'heebrea',
        'eu': 'hebreera',
        'fa': 'عبری',
        'fi': 'heprea',
        'fo': 'hebraiskt',
        'fr': 'hébreu',
        'gl': 'hebreo',
        'he': 'עברית',
        'hr': 'hebrejski',
        'hu': 'héber',
        'id': 'Ibrani',
        'ie': 'hebreic',
        'is': 'hebreska',
        'it': 'ebraico',
        'ja': 'ヘブライ語',
        'ko': '히브리어',
        'lt': 'hebrajų',
        'nb': 'hebraisk',
        'nl': 'Hebreeuws',
        'nn': 'hebraisk',
        'pl': 'hebrajski',
        'pt': 'hebraico',
        'pt_BR': 'hebraico',
        'ro': 'ebraică',
        'ru': 'иврит',
        'sk': 'hebrejčina',
        'sl': 'hebrejščina',
        'sr': 'хебрејски',
        'sr_Latn': 'hebrejski',
        'sv': 'hebreiska',
        'th': 'ฮิบรู',
        'tr': 'İbranice',
        'uk': 'іврит',
        'vi': 'Tiếng Do Thái',
        'zh_CN': '希伯来语',
        'zh_TW': '希伯來文',
    },
    'hr': {
        '_native': 'hrvatski',
        'ar': 'الكرواتية',
        'bg': 'хърватски',
        'bs': 'hrvatski',
        'ca': 'croat',
        'cs': 'chorvatština',
        'da': 'kroatisk',
        'de': 'Kroatisch',
        'el': 'Κροατικά',
        'en': 'Croatian',
        'eo': 'kroata',
        'es': 'croata',
        'et': 'horvaadi',
        'eu': 'kroaziera',
        'fa': 'کروات',
        'fi': 'kroatia',
        'fo': 'kroatiskt',
        'fr': 'croate',
        'gl': 'croata',
        'he': 'קרואטית',
        'hr': 'hrvatski',
        'hu': 'horvát',
        'id': 'Kroasia',
        'ie': 'croatian',
        'is': 'króatíska',
        'it': 'croato',
        'ja': 'クロアチア語',
        'ko': '크로아티아어',
        'lt': 'kroatų',
        'nb': 'kroatisk',
        'nl': 'Kroatisch',
        'nn': 'kroatisk',
        'pl': 'chorwacki',
        'pt': 'croata',
        'pt_BR': 'croata',
        'ro': 'croată',
        'ru': 'хорватский',
        'sk': 'chorvátčina',
        'sl': 'hrvaščina',
        'sr': 'хрватски',
        'sr_Latn': 'hrvatski',
        'sv': 'kroatiska',
        'th': 'โครเอเชีย',
        'tr': 'Hırvatça',
        'uk': 'хорватська',
        'vi': 'Tiếng Croatia',
        'zh_CN': '克罗地亚语',
        'zh_TW': '克羅埃西亞文',
    },
    'hu': {
        '_native': 'magyar',
        'ar': 'الهنغارية',
        'bg': 'унгарски',
        'bs': 'mađarski',
        'ca': 'hongarès',
        'cs': 'maďarština',
        'da': 'ungarsk',
        'de': 'Ungarisch',
        'el': 'Ουγγρικά',
        'en': 'Hungarian',
        'eo': 'hungara',
        'es': 'húngaro',
        'et': 'ungari',
        'eu': 'hungariera',
        'fa': 'مجاری',
        'fi': 'unkari',
        'fo': 'ungarskt',
        'fr': 'hongrois',
        'gl': 'húngaro',
        'he': 'הונגרית',
        'hr': 'mađarski',
        'hu': 'magyar',
        'id': 'Hungaria',
        'ie': 'hungarian',
        'is': 'ungverska',
        'it': 'ungherese',
        'ja': 'ハンガリー語',
        'ko': '헝가리어',
        'lt': 'vengrų',
        'nb': 'ungarsk',
        'nl': 'Hongaars',
        'nn': 'ungarsk',
        'pl': 'węgierski',
        'pt': 'húngaro',
        'pt_BR': 'húngaro',
        'ro': 'maghiară',
        'ru': 'венгерский',
        'sk': 'maďarčina',
        'sl': 'madžarščina',
        'sr': 'мађарски',
        'sr_Latn': 'mađarski',
        'sv': 'ungerska',
        'th': 'ฮังการี',
        'tr': 'Macarca',
        'uk': 'угорська',
        'vi': 'Tiếng Hungary',
        'zh_CN': '匈牙利语',
        'zh_TW': '匈牙利文',
    },
    'id': {
        '_native': 'Indonesia',
        'ar': 'الإندونيسية',
        'bg': 'индонезийски',
        'bs': 'indonezijski',
        'ca': 'indonesi',
        'cs': 'indonéština',
        'da': 'indonesisk',
        'de': 'Indonesisch',
        'el': 'Ινδονησιακά',
        'en': 'Indonesian',
        'eo': 'indonezia',
        'es': 'indonesio',
        'et': 'indoneesia',
        'eu': 'indonesiera',
        'fa': 'اندونزیایی',
        'fi': 'indonesia',
        'fo': 'indonesiskt',
        'fr': 'indonésien',
        'gl': 'indonesio',
        'he': 'אינדונזית',
        'hr': 'indonezijski',
        'hu': 'indonéz',
        'id': 'Indonesia',
        'ie': 'indonesian',
        'is': 'indónesíska',
        'it': 'indonesiano',
        'ja': 'インドネシア語',
        'ko': '인도네시아어',
        'lt': 'indoneziečių',
        'nb': 'indonesisk',
        'nl': 'Indonesisch',
        'nn': 'indonesisk',
        'pl': 'indonezyjski',
        'pt': 'indonésio',
        'pt_BR': 'indonésio',
        'ro': 'indoneziană',
        'ru': 'индонезийский',
        'sk': 'indonézština',
        'sl': 'indonezijščina',
        'sr': 'индонежански',
        'sr_Latn': 'indonežanski',
        'sv': 'indonesiska',
        'th': 'อินโดนีเซีย',
        'tr': 'Endonezce',
        'uk': 'індонезійська',
        'vi': 'Tiếng Indonesia',
        'zh_CN': '印度尼西亚语',
        'zh_TW': '印尼文',
    },
    'ie': {
        '_native': 'Interlingue',
        'ar': 'الإنترلينج',
        'bg': 'оксидентал',
        'bs': 'interlingve',
        'ca': 'interlingue',
        'cs': 'interlingue',
        'da': 'interlingue',
        'de': 'Interlingue',
        'el': 'Ιντερλίνγκουε',
        'en': 'Interlingue',
        'eo': 'Interlingveo',
        'es': 'interlingue',
        'et': 'interlingue',
        'eu': 'interlingue',
        'fa': 'اکسیدنتال',
        'fi': 'interlingue',
        'fo': 'interlingue',
        'fr': 'interlingue',
        'gl': 'None',
        'he': 'אינטרלינגה',
        'hr': 'interligua',
        'hu': 'interlingue',
        'id': 'Interlingue',
        'ie': 'Interlingue',
        'is': 'interlingve',
        'it': 'interlingue',
        'ja': 'インターリング',
        'ko': '인테르링구에',
        'lt': 'interkalba',
        'nb': 'interlingue',
        'nl': 'Interlingue',
        'nn': 'interlingue',
        'pl': 'interlingue',
        'pt': 'interlingue',
        'pt_BR': 'interlingue',
        'ro': 'interlingue',
        'ru': 'интерлингве',
        'sk': 'interlingue',
        'sl': 'interlingve',
        'sr': 'интерлингве',
        'sr_Latn': 'interlingve',
        'sv': 'interlingue',
        'th': 'อินเตอร์ลิงกิว',
        'tr': 'Interlingue',
        'uk': 'інтерлінгве',
        'vi': 'Tiếng Interlingue',
        'zh_CN': '国际文字（E）',
        'zh_TW': '國際文（E）',
    },
    'is': {
        '_native': 'íslenska',
        'ar': 'الأيسلندية',
        'bg': 'исландски',
        'bs': 'islandski',
        'ca': 'islandès',
        'cs': 'islandština',
        'da': 'islandsk',
        'de': 'Isländisch',
        'el': 'Ισλανδικά',
        'en': 'Icelandic',
        'eo': 'islanda',
        'es': 'islandés',
        'et': 'islandi',
        'eu': 'islandiera',
        'fa': 'ایسلندی',
        'fi': 'islanti',
        'fo': 'íslendskt',
        'fr': 'islandais',
        'gl': 'islandés',
        'he': 'איסלנדית',
        'hr': 'islandski',
        'hu': 'izlandi',
        'id': 'Islandia',
        'ie': 'islandesi',
        'is': 'íslenska',
        'it': 'islandese',
        'ja': 'アイスランド語',
        'ko': '아이슬란드어',
        'lt': 'islandų',
        'nb': 'islandsk',
        'nl': 'IJslands',
        'nn': 'islandsk',
        'pl': 'islandzki',
        'pt': 'islandês',
        'pt_BR': 'islandês',
        'ro': 'islandeză',
        'ru': 'исландский',
        'sk': 'islandčina',
        'sl': 'islandščina',
        'sr': 'исландски',
        'sr_Latn': 'islandski',
        'sv': 'isländska',
        'th': 'ไอซ์แลนด์',
        'tr': 'İzlandaca',
        'uk': 'ісландська',
        'vi': 'Tiếng Iceland',
        'zh_CN': '冰岛语',
        'zh_TW': '冰島文',
    },
    'it': {
        '_native': 'italiano',
        'ar': 'الإيطالية',
        'bg': 'италиански',
        'bs': 'italijanski',
        'ca': 'italià',
        'cs': 'italština',
        'da': 'italiensk',
        'de': 'Italienisch',
        'el': 'Ιταλικά',
        'en': 'Italian',
        'eo': 'itala',
        'es': 'italiano',
        'et': 'itaalia',
        'eu': 'italiera',
        'fa': 'ایتالیایی',
        'fi': 'italia',
        'fo': 'italskt',
        'fr': 'italien',
        'gl': 'italiano',
        'he': 'איטלקית',
        'hr': 'talijanski',
        'hu': 'olasz',
        'id': 'Italia',
        'ie': 'italian',
        'is': 'ítalska',
        'it': 'italiano',
        'ja': 'イタリア語',
        'ko': '이탈리아어',
        'lt': 'italų',
        'nb': 'italiensk',
        'nl': 'Italiaans',
        'nn': 'italiensk',
        'pl': 'włoski',
        'pt': 'italiano',
        'pt_BR': 'italiano',
        'ro': 'italiană',
        'ru': 'итальянский',
        'sk': 'taliančina',
        'sl': 'italijanščina',
        'sr': 'италијански',
        'sr_Latn': 'italijanski',
        'sv': 'italienska',
        'th': 'อิตาลี',
        'tr': 'İtalyanca',
        'uk': 'італійська',
        'vi': 'Tiếng Italy',
        'zh_CN': '意大利语',
        'zh_TW': '義大利文',
    },
    'ja': {
        '_native': '日本語',
        'ar': 'اليابانية',
        'bg': 'японски',
        'bs': 'japanski',
        'ca': 'japonès',
        'cs': 'japonština',
        'da': 'japansk',
        'de': 'Japanisch',
        'el': 'Ιαπωνικά',
        'en': 'Japanese',
        'eo': 'japana',
        'es': 'japonés',
        'et': 'jaapani',
        'eu': 'japoniera',
        'fa': 'ژاپنی',
        'fi': 'japani',
        'fo': 'japanskt',
        'fr': 'japonais',
        'gl': 'xaponés',
        'he': 'יפנית',
        'hr': 'japanski',
        'hu': 'japán',
        'id': 'Jepang',
        'ie': 'japanesi',
        'is': 'japanska',
        'it': 'giapponese',
        'ja': '日本語',
        'ko': '일본어',
        'lt': 'japonų',
        'nb': 'japansk',
        'nl': 'Japans',
        'nn': 'japansk',
        'pl': 'japoński',
        'pt': 'japonês',
        'pt_BR': 'japonês',
        'ro': 'japoneză',
        'ru': 'японский',
        'sk': 'japončina',
        'sl': 'japonščina',
        'sr': 'јапански',
        'sr_Latn': 'japanski',
        'sv': 'japanska',
        'th': 'ญี่ปุ่น',
        'tr': 'Japonca',
        'uk': 'японська',
        'vi': 'Tiếng Nhật',
        'zh_CN': '日语',
        'zh_TW': '日文',
    },
    'ko': {
        '_native': '한국어',
        'ar': 'الكورية',
        'bg': 'корейски',
        'bs': 'korejski',
        'ca': 'coreà',
        'cs': 'korejština',
        'da': 'koreansk',
        'de': 'Koreanisch',
        'el': 'Κορεατικά',
        'en': 'Korean',
        'eo': 'korea',
        'es': 'coreano',
        'et': 'korea',
        'eu': 'koreera',
        'fa': 'کره‌ای',
        'fi': 'korea',
        'fo': 'koreanskt',
        'fr': 'coréen',
        'gl': 'coreano',
        'he': 'קוריאנית',
        'hr': 'korejski',
        'hu': 'koreai',
        'id': 'Korea',
        'ie': 'korean',
        'is': 'kóreska',
        'it': 'coreano',
        'ja': '韓国語',
        'ko': '한국어',
        'lt': 'korėjiečių',
        'nb': 'koreansk',
        'nl': 'Koreaans',
        'nn': 'koreansk',
        'pl': 'koreański',
        'pt': 'coreano',
        'pt_BR': 'coreano',
        'ro': 'coreeană',
        'ru': 'корейский',
        'sk': 'kórejčina',
        'sl': 'korejščina',
        'sr': 'корејски',
        'sr_Latn': 'korejski',
        'sv': 'koreanska',
        'th': 'เกาหลี',
        'tr': 'Korece',
        'uk': 'корейська',
        'vi': 'Tiếng Hàn',
        'zh_CN': '韩语',
        'zh_TW': '韓文',
    },
    'lt': {
        '_native': 'lietuvių',
        'ar': 'الليتوانية',
        'bg': 'литовски',
        'bs': 'litvanski',
        'ca': 'lituà',
        'cs': 'litevština',
        'da': 'litauisk',
        'de': 'Litauisch',
        'el': 'Λιθουανικά',
        'en': 'Lithuanian',
        'eo': 'litova',
        'es': 'lituano',
        'et': 'leedu',
        'eu': 'lituaniera',
        'fa': 'لیتوانیایی',
        'fi': 'liettua',
        'fo': 'litaviskt',
        'fr': 'lituanien',
        'gl': 'lituano',
        'he': 'ליטאית',
        'hr': 'litavski',
        'hu': 'litván',
        'id': 'Lituavi',
        'ie': 'lituan',
        'is': 'litháíska',
        'it': 'lituano',
        'ja': 'リトアニア語',
        'ko': '리투아니아어',
        'lt': 'lietuvių',
        'nb': 'litauisk',
        'nl': 'Litouws',
        'nn': 'litauisk',
        'pl': 'litewski',
        'pt': 'lituano',
        'pt_BR': 'lituano',
        'ro': 'lituaniană',
        'ru': 'литовский',
        'sk': 'litovčina',
        'sl': 'litovščina',
        'sr': 'литвански',
        'sr_Latn': 'litvanski',
        'sv': 'litauiska',
        'th': 'ลิทัวเนีย',
        'tr': 'Litvanca',
        'uk': 'литовська',
        'vi': 'Tiếng Litva',
        'zh_CN': '立陶宛语',
        'zh_TW': '立陶宛文',
    },
    'nb': {
        '_native': 'norsk bokmål',
        'ar': 'النرويجية بوكمال',
        'bg': 'норвежки (букмол)',
        'bs': 'norveški (Bokmal)',
        'ca': 'noruec bokmål',
        'cs': 'norština (bokmål)',
        'da': 'bokmål',
        'de': 'Norwegisch (Bokmål)',
        'el': 'Νορβηγικά Μποκμάλ',
        'en': 'Norwegian Bokmål',
        'eo': 'dannorvega',
        'es': 'noruego bokmal',
        'et': 'norra bokmål',
        'eu': 'bokmål (norvegiera)',
        'fa': 'نروژی بوک‌مُل',
        'fi': 'norjan bokmål',
        'fo': 'norskt bókmál',
        'fr': 'norvégien bokmål',
        'gl': 'noruegués bokmål',
        'he': 'נורווגית ספרותית',
        'hr': 'norveški bokmål',
        'hu': 'norvég (bokmål)',
        'id': 'Bokmål Norwegia',
        'ie': 'norvegian, bokmål',
        'is': 'norskt bókmál',
        'it': 'norvegese bokmål',
        'ja': 'ノルウェー語(ブークモール)',
        'ko': '노르웨이어(보크말)',
        'lt': 'norvegų bukmolas',
        'nb': 'norsk bokmål',
        'nl': 'Noors - Bokmål',
        'nn': 'norsk bokmål',
        'pl': 'norweski (bokmål)',
        'pt': 'bokmål norueguês',
        'pt_BR': 'bokmål norueguês',
        'ro': 'norvegiană bokmål',
        'ru': 'норвежский букмол',
        'sk': 'nórčina (bokmal)',
        'sl': 'knjižna norveščina',
        'sr': 'норвешки букмол',
        'sr_Latn': 'norveški bukmol',
        'sv': 'norskt bokmål',
        'th': 'นอร์เวย์บุคมอล',
        'tr': 'Norveççe Bokmål',
        'uk': 'норвезька (букмол)',
        'vi': 'Tiếng Na Uy (Bokmål)',
        'zh_CN': '书面挪威语',
        'zh_TW': '巴克摩挪威文',
    },
    'nl': {
        '_native': 'Nederlands',
        'ar': 'الهولندية',
        'bg': 'нидерландски',
        'bs': 'nizozemski',
        'ca': 'neerlandès',
        'cs': 'nizozemština',
        'da': 'nederlandsk',
        'de': 'Niederländisch',
        'el': 'Ολλανδικά',
        'en': 'Dutch',
        'eo': 'nederlanda',
        'es': 'neerlandés',
        'et': 'hollandi',
        'eu': 'nederlandera',
        'fa': 'هلندی',
        'fi': 'hollanti',
        'fo': 'hálendskt',
        'fr': 'néerlandais',
        'gl': 'neerlandés',
        'he': 'הולנדית',
        'hr': 'nizozemski',
        'hu': 'holland',
        'id': 'Belanda',
        'ie': 'hollandesi',
        'is': 'hollenska',
        'it': 'olandese',
        'ja': 'オランダ語',
        'ko': '네덜란드어',
        'lt': 'olandų',
        'nb': 'nederlandsk',
        'nl': 'Nederlands',
        'nn': 'nederlandsk',
        'pl': 'niderlandzki',
        'pt': 'holandês',
        'pt_BR': 'holandês',
        'ro': 'neerlandeză',
        'ru': 'нидерландский',
        'sk': 'holandčina',
        'sl': 'nizozemščina',
        'sr': 'холандски',
        'sr_Latn': 'holandski',
        'sv': 'nederländska',
        'th': 'ดัตช์',
        'tr': 'Felemenkçe',
        'uk': 'нідерландська',
        'vi': 'Tiếng Hà Lan',
        'zh_CN': '荷兰语',
        'zh_TW': '荷蘭文',
    },
    'nn': {
        '_native': 'norsk nynorsk',
        'ar': 'النرويجية نينورسك',
        'bg': 'норвежки (нюношк)',
        'bs': 'norveški (Nynorsk)',
        'ca': 'noruec nynorsk',
        'cs': 'norština (nynorsk)',
        'da': 'nynorsk',
        'de': 'Norwegisch (Nynorsk)',
        'el': 'Νορβηγικά Νινόρσκ',
        'en': 'Norwegian Nynorsk',
        'eo': 'novnorvega',
        'es': 'noruego nynorsk',
        'et': 'uusnorra',
        'eu': 'nynorsk (norvegiera)',
        'fa': 'نروژی نی‌نُشک',
        'fi': 'norjan nynorsk',
        'fo': 'nýnorskt',
        'fr': 'norvégien nynorsk',
        'gl': 'noruegués nynorsk',
        'he': 'נורווגית חדשה',
        'hr': 'norveški nynorsk',
        'hu': 'norvég (nynorsk)',
        'id': 'Nynorsk Norwegia',
        'ie': 'neo-norvegian',
        'is': 'nýnorska',
        'it': 'norvegese nynorsk',
        'ja': 'ノルウェー語(ニーノシュク)',
        'ko': '노르웨이어(니노르스크)',
        'lt': 'naujoji norvegų',
        'nb': 'norsk nynorsk',
        'nl': 'Noors - Nynorsk',
        'nn': 'norsk nynorsk',
        'pl': 'norweski (nynorsk)',
        'pt': 'nynorsk norueguês',
        'pt_BR': 'nynorsk norueguês',
        'ro': 'norvegiană nynorsk',
        'ru': 'нюнорск',
        'sk': 'nórčina (nynorsk)',
        'sl': 'novonorveščina',
        'sr': 'норвешки нинорск',
        'sr_Latn': 'norveški ninorsk',
        'sv': 'nynorska',
        'th': 'นอร์เวย์นีนอสก์',
        'tr': 'Norveççe Nynorsk',
        'uk': 'норвезька (нюношк)',
        'vi': 'Tiếng Na Uy (Nynorsk)',
        'zh_CN': '挪威尼诺斯克语',
        'zh_TW': '耐諾斯克挪威文',
    },
    'pl': {
        '_native': 'polski',
        'ar': 'البولندية',
        'bg': 'полски',
        'bs': 'poljski',
        'ca': 'polonès',
        'cs': 'polština',
        'da': 'polsk',
        'de': 'Polnisch',
        'el': 'Πολωνικά',
        'en': 'Polish',
        'eo': 'pola',
        'es': 'polaco',
        'et': 'poola',
        'eu': 'poloniera',
        'fa': 'لهستانی',
        'fi': 'puola',
        'fo': 'pólskt',
        'fr': 'polonais',
        'gl': 'polaco',
        'he': 'פולנית',
        'hr': 'poljski',
        'hu': 'lengyel',
        'id': 'Polski',
        'ie': 'polonesi',
        'is': 'pólska',
        'it': 'polacco',
        'ja': 'ポーランド語',
        'ko': '폴란드어',
        'lt': 'lenkų',
        'nb': 'polsk',
        'nl': 'Pools',
        'nn': 'polsk',
        'pl': 'polski',
        'pt': 'polonês',
        'pt_BR': 'polonês',
        'ro': 'poloneză',
        'ru': 'польский',
        'sk': 'poľština',
        'sl': 'poljščina',
        'sr': 'пољски',
        'sr_Latn': 'poljski',
        'sv': 'polska',
        'th': 'โปแลนด์',
        'tr': 'Lehçe',
        'uk': 'польська',
        'vi': 'Tiếng Ba Lan',
        'zh_CN': '波兰语',
        'zh_TW': '波蘭文',
    },
    'pt': {
        '_native': 'português',
        'ar': 'البرتغالية',
        'bg': 'португалски',
        'bs': 'portugalski',
        'ca': 'portuguès',
        'cs': 'portugalština',
        'da': 'portugisisk',
        'de': 'Portugiesisch',
        'el': 'Πορτογαλικά',
        'en': 'Portuguese',
        'eo': 'portugala',
        'es': 'portugués',
        'et': 'portugali',
        'eu': 'portugesa',
        'fa': 'پرتغالی',
        'fi': 'portugali',
        'fo': 'portugiskiskt',
        'fr': 'portugais',
        'gl': 'portugués',
        'he': 'פורטוגזית',
        'hr': 'portugalski',
        'hu': 'portugál',
        'id': 'Portugis',
        'ie': 'portugalesi',
        'is': 'portúgalska',
        'it': 'portoghese',
        'ja': 'ポルトガル語',
        'ko': '포르투갈어',
        'lt': 'portugalų',
        'nb': 'portugisisk',
        'nl': 'Portugees',
        'nn': 'portugisisk',
        'pl': 'portugalski',
        'pt': 'português',
        'pt_BR': 'português',
        'ro': 'portugheză',
        'ru': 'португальский',
        'sk': 'portugalčina',
        'sl': 'portugalščina',
        'sr': 'португалски',
        'sr_Latn': 'portugalski',
        'sv': 'portugisiska',
        'th': 'โปรตุเกส',
        'tr': 'Portekizce',
        'uk': 'португальська',
        'vi': 'Tiếng Bồ Đào Nha',
        'zh_CN': '葡萄牙语',
        'zh_TW': '葡萄牙文',
    },
    'pt_BR': {
        '_native': 'português (Brasil)',
        'ar': 'البرتغالية (البرازيل)',
        'bg': 'португалски (Бразилия)',
        'bs': 'portugalski (Brazil)',
        'ca': 'portuguès (Brasil)',
        'cs': 'portugalština (Brazílie)',
        'da': 'portugisisk (Brasilien)',
        'de': 'Portugiesisch (Brasilien)',
        'el': 'Πορτογαλικά (Βραζιλία)',
        'en': 'Portuguese (Brazil)',
        'eo': 'portugala (Brazilo)',
        'es': 'portugués (Brasil)',
        'et': 'portugali (Brasiilia)',
        'eu': 'portugesa (Brasil)',
        'fa': 'پرتغالی (برزیل)',
        'fi': 'portugali (Brasilia)',
        'fo': 'portugiskiskt (Brasil)',
        'fr': 'portugais (Brésil)',
        'gl': 'portugués (O Brasil)',
        'he': 'פורטוגזית (ברזיל)',
        'hr': 'portugalski (Brazil)',
        'hu': 'portugál (Brazília)',
        'id': 'Portugis (Brasil)',
        'ie': 'portugalesi (Brasilia)',
        'is': 'portúgalska (Brasilía)',
        'it': 'portoghese (Brasile)',
        'ja': 'ポルトガル語 (ブラジル)',
        'ko': '포르투갈어 (브라질)',
        'lt': 'portugalų (Brazilija)',
        'nb': 'portugisisk (Brasil)',
        'nl': 'Portugees (Brazilië)',
        'nn': 'portugisisk (Brasil)',
        'pl': 'portugalski (Brazylia)',
        'pt': 'português (Brasil)',
        'pt_BR': 'português (Brasil)',
        'ro': 'portugheză (Brazilia)',
        'ru': 'португальский (Бразилия)',
        'sk': 'portugalčina (Brazília)',
        'sl': 'portugalščina (Brazilija)',
        'sr': 'португалски (Бразил)',
        'sr_Latn': 'portugalski (Brazil)',
        'sv': 'portugisiska (Brasilien)',
        'th': 'โปรตุเกส (บราซิล)',
        'tr': 'Portekizce (Brezilya)',
        'uk': 'португальська (Бразилія)',
        'vi': 'Tiếng Bồ Đào Nha (Brazil)',
        'zh_CN': '葡萄牙语 (巴西)',
        'zh_TW': '葡萄牙文 (巴西)',
    },
    'ro': {
        '_native': 'română',
        'ar': 'الرومانية',
        'bg': 'румънски',
        'bs': 'rumunski',
        'ca': 'romanès',
        'cs': 'rumunština',
        'da': 'rumænsk',
        'de': 'Rumänisch',
        'el': 'Ρουμανικά',
        'en': 'Romanian',
        'eo': 'rumana',
        'es': 'rumano',
        'et': 'rumeenia',
        'eu': 'errumaniera',
        'fa': 'رومانیایی',
        'fi': 'romania',
        'fo': 'rumenskt',
        'fr': 'roumain',
        'gl': 'romanés',
        'he': 'רומנית',
        'hr': 'rumunjski',
        'hu': 'román',
        'id': 'Rumania',
        'ie': 'rumanian',
        'is': 'rúmenska',
        'it': 'rumeno',
        'ja': 'ルーマニア語',
        'ko': '루마니아어',
        'lt': 'rumunų',
        'nb': 'rumensk',
        'nl': 'Roemeens',
        'nn': 'rumensk',
        'pl': 'rumuński',
        'pt': 'romeno',
        'pt_BR': 'romeno',
        'ro': 'română',
        'ru': 'румынский',
        'sk': 'rumunčina',
        'sl': 'romunščina',
        'sr': 'румунски',
        'sr_Latn': 'rumunski',
        'sv': 'rumänska',
        'th': 'โรมาเนีย',
        'tr': 'Rumence',
        'uk': 'румунська',
        'vi': 'Tiếng Romania',
        'zh_CN': '罗马尼亚语',
        'zh_TW': '羅馬尼亞文',
    },
    'ru': {
        '_native': 'русский',
        'ar': 'الروسية',
        'bg': 'руски',
        'bs': 'ruski',
        'ca': 'rus',
        'cs': 'ruština',
        'da': 'russisk',
        'de': 'Russisch',
        'el': 'Ρωσικά',
        'en': 'Russian',
        'eo': 'rusa',
        'es': 'ruso',
        'et': 'vene',
        'eu': 'errusiera',
        'fa': 'روسی',
        'fi': 'venäjä',
        'fo': 'russiskt',
        'fr': 'russe',
        'gl': 'ruso',
        'he': 'רוסית',
        'hr': 'ruski',
        'hu': 'orosz',
        'id': 'Rusia',
        'ie': 'russ',
        'is': 'rússneska',
        'it': 'russo',
        'ja': 'ロシア語',
        'ko': '러시아어',
        'lt': 'rusų',
        'nb': 'russisk',
        'nl': 'Russisch',
        'nn': 'russisk',
        'pl': 'rosyjski',
        'pt': 'russo',
        'pt_BR': 'russo',
        'ro': 'rusă',
        'ru': 'русский',
        'sk': 'ruština',
        'sl': 'ruščina',
        'sr': 'руски',
        'sr_Latn': 'ruski',
        'sv': 'ryska',
        'th': 'รัสเซีย',
        'tr': 'Rusça',
        'uk': 'російська',
        'vi': 'Tiếng Nga',
        'zh_CN': '俄语',
        'zh_TW': '俄文',
    },
    'sk': {
        '_native': 'slovenčina',
        'ar': 'السلوفاكية',
        'bg': 'словашки',
        'bs': 'slovački',
        'ca': 'eslovac',
        'cs': 'slovenština',
        'da': 'slovakisk',
        'de': 'Slowakisch',
        'el': 'Σλοβακικά',
        'en': 'Slovak',
        'eo': 'slovaka',
        'es': 'eslovaco',
        'et': 'slovaki',
        'eu': 'eslovakiera',
        'fa': 'اسلواکی',
        'fi': 'slovakki',
        'fo': 'slovakiskt',
        'fr': 'slovaque',
        'gl': 'eslovaco',
        'he': 'סלובקית',
        'hr': 'slovački',
        'hu': 'szlovák',
        'id': 'Slovak',
        'ie': 'slovac',
        'is': 'slóvakíska',
        'it': 'slovacco',
        'ja': 'スロバキア語',
        'ko': '슬로바키아어',
        'lt': 'slovakų',
        'nb': 'slovakisk',
        'nl': 'Slowaaks',
        'nn': 'slovakisk',
        'pl': 'słowacki',
        'pt': 'eslovaco',
        'pt_BR': 'eslovaco',
        'ro': 'slovacă',
        'ru': 'словацкий',
        'sk': 'slovenčina',
        'sl': 'slovaščina',
        'sr': 'словачки',
        'sr_Latn': 'slovački',
        'sv': 'slovakiska',
        'th': 'สโลวัก',
        'tr': 'Slovakça',
        'uk': 'словацька',
        'vi': 'Tiếng Slovak',
        'zh_CN': '斯洛伐克语',
        'zh_TW': '斯洛伐克文',
    },
    'sl': {
        '_native': 'slovenščina',
        'ar': 'السلوفانية',
        'bg': 'словенски',
        'bs': 'slovenski',
        'ca': 'eslovè',
        'cs': 'slovinština',
        'da': 'slovensk',
        'de': 'Slowenisch',
        'el': 'Σλοβενικά',
        'en': 'Slovenian',
        'eo': 'slovena',
        'es': 'esloveno',
        'et': 'sloveeni',
        'eu': 'esloveniera',
        'fa': 'اسلوونیایی',
        'fi': 'sloveeni',
        'fo': 'slovenskt',
        'fr': 'slovène',
        'gl': 'esloveno',
        'he': 'סלובנית',
        'hr': 'slovenski',
        'hu': 'szlovén',
        'id': 'Sloven',
        'ie': 'slovenian',
        'is': 'slóvenska',
        'it': 'sloveno',
        'ja': 'スロベニア語',
        'ko': '슬로베니아어',
        'lt': 'slovėnų',
        'nb': 'slovensk',
        'nl': 'Sloveens',
        'nn': 'slovensk',
        'pl': 'słoweński',
        'pt': 'esloveno',
        'pt_BR': 'esloveno',
        'ro': 'slovenă',
        'ru': 'словенский',
        'sk': 'slovinčina',
        'sl': 'slovenščina',
        'sr': 'словеначки',
        'sr_Latn': 'slovenački',
        'sv': 'slovenska',
        'th': 'สโลวีเนีย',
        'tr': 'Slovence',
        'uk': 'словенська',
        'vi': 'Tiếng Slovenia',
        'zh_CN': '斯洛文尼亚语',
        'zh_TW': '斯洛維尼亞文',
    },
    'sr': {
        '_native': 'српски',
        'ar': 'الصربية',
        'bg': 'сръбски',
        'bs': 'srpski',
        'ca': 'serbi',
        'cs': 'srbština',
        'da': 'serbisk',
        'de': 'Serbisch',
        'el': 'Σερβικά',
        'en': 'Serbian',
        'eo': 'serba',
        'es': 'serbio',
        'et': 'serbia',
        'eu': 'serbiera',
        'fa': 'صربی',
        'fi': 'serbia',
        'fo': 'serbiskt',
        'fr': 'serbe',
        'gl': 'serbio',
        'he': 'סרבית',
        'hr': 'srpski',
        'hu': 'szerb',
        'id': 'Serbia',
        'ie': 'serbian',
        'is': 'serbneska',
        'it': 'serbo',
        'ja': 'セルビア語',
        'ko': '세르비아어',
        'lt': 'serbų',
        'nb': 'serbisk',
        'nl': 'Servisch',
        'nn': 'serbisk',
        'pl': 'serbski',
        'pt': 'sérvio',
        'pt_BR': 'sérvio',
        'ro': 'sârbă',
        'ru': 'сербский',
        'sk': 'srbčina',
        'sl': 'srbščina',
        'sr': 'српски',
        'sr_Latn': 'srpski',
        'sv': 'serbiska',
        'th': 'เซอร์เบีย',
        'tr': 'Sırpça',
        'uk': 'сербська',
        'vi': 'Tiếng Serbia',
        'zh_CN': '塞尔维亚语',
        'zh_TW': '塞爾維亞文',
    },
    'sr_Latn': {
        '_native': 'srpski (latinica)',
        'ar': 'الصربية (اللاتينية)',
        'bg': 'сръбски (латиница)',
        'bs': 'srpski (latinica)',
        'ca': 'serbi (llatí)',
        'cs': 'srbština (latinka)',
        'da': 'serbisk (latinsk)',
        'de': 'Serbisch (Lateinisch)',
        'el': 'Σερβικά (Λατινικό)',
        'en': 'Serbian (Latin)',
        'eo': 'serba (latina)',
        'es': 'serbio (latino)',
        'et': 'serbia (ladina)',
        'eu': 'serbiera (latinoa)',
        'fa': 'صربی (لاتین)',
        'fi': 'serbia (latinalainen)',
        'fo': 'serbiskt (latínskt)',
        'fr': 'serbe (latin)',
        'gl': 'serbio (latino)',
        'he': 'סרבית (לטיני)',
        'hr': 'srpski (latinica)',
        'hu': 'szerb (Latin)',
        'id': 'Serbia (Latin)',
        'ie': 'serbian (latin)',
        'is': 'serbneska (latneskt)',
        'it': 'serbo (latino)',
        'ja': 'セルビア語 (ラテン文字)',
        'ko': '세르비아어 (로마자)',
        'lt': 'serbų (lotynų)',
        'nb': 'serbisk (latinsk)',
        'nl': 'Servisch (Latijns)',
        'nn': 'serbisk (latinsk)',
        'pl': 'serbski (łacińskie)',
        'pt': 'sérvio (latim)',
        'pt_BR': 'sérvio (latim)',
        'ro': 'sârbă (latină)',
        'ru': 'сербский (латиница)',
        'sk': 'srbčina (latinka)',
        'sl': 'srbščina (latinica)',
        'sr': 'српски (латиница)',
        'sr_Latn': 'srpski (latinica)',
        'sv': 'serbiska (latinska)',
        'th': 'เซอร์เบีย (ละติน)',
        'tr': 'Sırpça (Latin)',
        'uk': 'сербська (латиниця)',
        'vi': 'Tiếng Serbia (Chữ La tinh)',
        'zh_CN': '塞尔维亚语 (拉丁文)',
        'zh_TW': '塞爾維亞文 (拉丁文)',
    },
    'sv': {
        '_native': 'svenska',
        'ar': 'السويدية',
        'bg': 'шведски',
        'bs': 'švedski',
        'ca': 'suec',
        'cs': 'švédština',
        'da': 'svensk',
        'de': 'Schwedisch',
        'el': 'Σουηδικά',
        'en': 'Swedish',
        'eo': 'sveda',
        'es': 'sueco',
        'et': 'rootsi',
        'eu': 'suediera',
        'fa': 'سوئدی',
        'fi': 'ruotsi',
        'fo': 'svenskt',
        'fr': 'suédois',
        'gl': 'sueco',
        'he': 'שוודית',
        'hr': 'švedski',
        'hu': 'svéd',
        'id': 'Swedia',
        'ie': 'sved',
        'is': 'sænska',
        'it': 'svedese',
        'ja': 'スウェーデン語',
        'ko': '스웨덴어',
        'lt': 'švedų',
        'nb': 'svensk',
        'nl': 'Zweeds',
        'nn': 'svensk',
        'pl': 'szwedzki',
        'pt': 'sueco',
        'pt_BR': 'sueco',
        'ro': 'suedeză',
        'ru': 'шведский',
        'sk': 'švédčina',
        'sl': 'švedščina',
        'sr': 'шведски',
        'sr_Latn': 'švedski',
        'sv': 'svenska',
        'th': 'สวีเดน',
        'tr': 'İsveççe',
        'uk': 'шведська',
        'vi': 'Tiếng Thụy Điển',
        'zh_CN': '瑞典语',
        'zh_TW': '瑞典文',
    },
    'th': {
        '_native': 'ไทย',
        'ar': 'التايلاندية',
        'bg': 'тайски',
        'bs': 'tajlandski',
        'ca': 'tai',
        'cs': 'thajština',
        'da': 'thai',
        'de': 'Thailändisch',
        'el': 'Ταϊλανδικά',
        'en': 'Thai',
        'eo': 'taja',
        'es': 'tailandés',
        'et': 'tai',
        'eu': 'thailandiera',
        'fa': 'تایلندی',
        'fi': 'thai',
        'fo': 'tailendskt',
        'fr': 'thaï',
        'gl': 'tailandés',
        'he': 'תאית',
        'hr': 'tajlandski',
        'hu': 'thai',
        'id': 'Thai',
        'ie': 'thai',
        'is': 'taílenska',
        'it': 'thailandese',
        'ja': 'タイ語',
        'ko': '태국어',
        'lt': 'tajų',
        'nb': 'thai',
        'nl': 'Thai',
        'nn': 'thai',
        'pl': 'tajski',
        'pt': 'tailandês',
        'pt_BR': 'tailandês',
        'ro': 'thailandeză',
        'ru': 'тайский',
        'sk': 'thajčina',
        'sl': 'tajščina',
        'sr': 'тајски',
        'sr_Latn': 'tajski',
        'sv': 'thailändska',
        'th': 'ไทย',
        'tr': 'Tayca',
        'uk': 'тайська',
        'vi': 'Tiếng Thái',
        'zh_CN': '泰语',
        'zh_TW': '泰文',
    },
    'tr': {
        '_native': 'Türkçe',
        'ar': 'التركية',
        'bg': 'турски',
        'bs': 'turski',
        'ca': 'turc',
        'cs': 'turečtina',
        'da': 'tyrkisk',
        'de': 'Türkisch',
        'el': 'Τουρκικά',
        'en': 'Turkish',
        'eo': 'turka',
        'es': 'turco',
        'et': 'türgi',
        'eu': 'turkiera',
        'fa': 'ترکی استانبولی',
        'fi': 'turkki',
        'fo': 'turkiskt',
        'fr': 'turc',
        'gl': 'turco',
        'he': 'טורקית',
        'hr': 'turski',
        'hu': 'török',
        'id': 'Turki',
        'ie': 'turc',
        'is': 'tyrkneska',
        'it': 'turco',
        'ja': 'トルコ語',
        'ko': '터키어',
        'lt': 'turkų',
        'nb': 'tyrkisk',
        'nl': 'Turks',
        'nn': 'tyrkisk',
        'pl': 'turecki',
        'pt': 'turco',
        'pt_BR': 'turco',
        'ro': 'turcă',
        'ru': 'турецкий',
        'sk': 'turečtina',
        'sl': 'turščina',
        'sr': 'турски',
        'sr_Latn': 'turski',
        'sv': 'turkiska',
        'th': 'ตุรกี',
        'tr': 'Türkçe',
        'uk': 'турецька',
        'vi': 'Tiếng Thổ Nhĩ Kỳ',
        'zh_CN': '土耳其语',
        'zh_TW': '土耳其文',
    },
    'uk': {
        '_native': 'українська',
        'ar': 'الأوكرانية',
        'bg': 'украински',
        'bs': 'ukrajinski',
        'ca': 'ucraïnès',
        'cs': 'ukrajinština',
        'da': 'ukrainsk',
        'de': 'Ukrainisch',
        'el': 'Ουκρανικά',
        'en': 'Ukrainian',
        'eo': 'ukraina',
        'es': 'ucraniano',
        'et': 'ukraina',
        'eu': 'ukrainera',
        'fa': 'اوکراینی',
        'fi': 'ukraina',
        'fo': 'ukrainskt',
        'fr': 'ukrainien',
        'gl': 'ucraíno',
        'he': 'אוקראינית',
        'hr': 'ukrajinski',
        'hu': 'ukrán',
        'id': 'Ukraina',
        'ie': 'ukrainan',
        'is': 'úkraínska',
        'it': 'ucraino',
        'ja': 'ウクライナ語',
        'ko': '우크라이나어',
        'lt': 'ukrainiečių',
        'nb': 'ukrainsk',
        'nl': 'Oekraïens',
        'nn': 'ukrainsk',
        'pl': 'ukraiński',
        'pt': 'ucraniano',
        'pt_BR': 'ucraniano',
        'ro': 'ucraineană',
        'ru': 'украинский',
        'sk': 'ukrajinčina',
        'sl': 'ukrajinščina',
        'sr': 'украјински',
        'sr_Latn': 'ukrajinski',
        'sv': 'ukrainska',
        'th': 'ยูเครน',
        'tr': 'Ukraynaca',
        'uk': 'українська',
        'vi': 'Tiếng Ukraina',
        'zh_CN': '乌克兰语',
        'zh_TW': '烏克蘭文',
    },
    'vi': {
        '_native': 'Tiếng Việt',
        'ar': 'الفيتنامية',
        'bg': 'виетнамски',
        'bs': 'vijetnamski',
        'ca': 'vietnamita',
        'cs': 'vietnamština',
        'da': 'vietnamesisk',
        'de': 'Vietnamesisch',
        'el': 'Βιετναμικά',
        'en': 'Vietnamese',
        'eo': 'vjetnama',
        'es': 'vietnamita',
        'et': 'vietnami',
        'eu': 'vietnamera',
        'fa': 'ویتنامی',
        'fi': 'vietnam',
        'fo': 'vjetnamesiskt',
        'fr': 'vietnamien',
        'gl': 'vietnamita',
        'he': 'וייטנאמית',
        'hr': 'vijetnamski',
        'hu': 'vietnámi',
        'id': 'Vietnam',
        'ie': 'vietnamesi',
        'is': 'víetnamska',
        'it': 'vietnamita',
        'ja': 'ベトナム語',
        'ko': '베트남어',
        'lt': 'vietnamiečių',
        'nb': 'vietnamesisk',
        'nl': 'Vietnamees',
        'nn': 'vietnamesisk',
        'pl': 'wietnamski',
        'pt': 'vietnamita',
        'pt_BR': 'vietnamita',
        'ro': 'vietnameză',
        'ru': 'вьетнамский',
        'sk': 'vietnamčina',
        'sl': 'vietnamščina',
        'sr': 'вијетнамски',
        'sr_Latn': 'vijetnamski',
        'sv': 'vietnamesiska',
        'th': 'เวียดนาม',
        'tr': 'Vietnamca',
        'uk': 'вʼєтнамська',
        'vi': 'Tiếng Việt',
        'zh_CN': '越南语',
        'zh_TW': '越南文',
    },
    'zh_CN': {
        '_native': '中文 (简体, 中国)',
        'ar': 'الصينية (المبسطة, الصين)',
        'bg': 'китайски (опростена, Китай)',
        'bs': 'kineski (pojednostavljeno, Kina)',
        'ca': 'xinès (simplificat, Xina)',
        'cs': 'čínština (zjednodušené, Čína)',
        'da': 'kinesisk (forenklet, Kina)',
        'de': 'Chinesisch (Vereinfacht, China)',
        'el': 'Κινεζικά (Απλοποιημένο, Κίνα)',
        'en': 'Chinese (Simplified, China)',
        'eo': 'ĉina (simpligita, Ĉinujo)',
        'es': 'chino (simplificado, China)',
        'et': 'hiina (lihtsustatud, Hiina)',
        'eu': 'txinera (sinplifikatua, Txina)',
        'fa': 'چینی (ساده‌شده, چین)',
        'fi': 'kiina (yksinkertaistettu, Kiina)',
        'fo': 'kinesiskt (einkult, Kina)',
        'fr': 'chinois (simplifié, Chine)',
        'gl': 'chinés (simplificado, A China)',
        'he': 'סינית (פשוט, סין)',
        'hr': 'kineski (pojednostavljeno pismo, Kina)',
        'hu': 'kínai (Egyszerűsített, Kína)',
        'id': 'Tionghoa (Sederhana, Tiongkok)',
        'ie': 'chinesi (simplificat, China)',
        'is': 'kínverska (einfaldað, Kína)',
        'it': 'cinese (semplificato, Cina)',
        'ja': '中国語 (簡体字, 中国)',
        'ko': '중국어 (간체, 중국)',
        'lt': 'kinų (supaprastinti, Kinija)',
        'nb': 'kinesisk (forenklet, Kina)',
        'nl': 'Chinees (vereenvoudigd, China)',
        'nn': 'kinesisk (forenkla, Kina)',
        'pl': 'chiński (uproszczone, Chiny)',
        'pt': 'chinês (simplificado, China)',
        'pt_BR': 'chinês (simplificado, China)',
        'ro': 'chineză (simplificată, China)',
        'ru': 'китайский (упрощенная, Китай)',
        'sk': 'čínština (zjednodušené, Čína)',
        'sl': 'kitajščina (poenostavljena pisava, Kitajska)',
        'sr': 'кинески (поједностављено кинеско писмо, Кина)',
        'sr_Latn': 'kineski (pojednostavljeno kinesko pismo, Kina)',
        'sv': 'kinesiska (förenklad, Kina)',
        'th': 'จีน (ตัวย่อ, จีน)',
        'tr': 'Çince (Basitleştirilmiş, Çin)',
        'uk': 'китайська (спрощена, Китай)',
        'vi': 'Tiếng Trung (Giản thể, Trung Quốc)',
        'zh_CN': '中文 (简体, 中国)',
        'zh_TW': '中文 (簡體, 中國)',
    },
    'zh_TW': {
        '_native': '中文 (繁體, 台灣)',
        'ar': 'الصينية (التقليدية, تايوان)',
        'bg': 'китайски (традиционна, Тайван)',
        'bs': 'kineski (tradicionalno, Tajvan)',
        'ca': 'xinès (tradicional, Taiwan)',
        'cs': 'čínština (tradiční, Tchaj-wan)',
        'da': 'kinesisk (traditionelt, Taiwan)',
        'de': 'Chinesisch (Traditionell, Taiwan)',
        'el': 'Κινεζικά (Παραδοσιακό, Ταϊβάν)',
        'en': 'Chinese (Traditional, Taiwan)',
        'eo': 'ĉina (tradicia, Tajvano)',
        'es': 'chino (tradicional, Taiwán)',
        'et': 'hiina (traditsiooniline, Taiwan)',
        'eu': 'txinera (tradizionala, Taiwan)',
        'fa': 'چینی (سنتی, تایوان)',
        'fi': 'kiina (perinteinen, Taiwan)',
        'fo': 'kinesiskt (vanligt, Taivan)',
        'fr': 'chinois (traditionnel, Taïwan)',
        'gl': 'chinés (tradicional, Taiwán)',
        'he': 'סינית (מסורתי, טייוואן)',
        'hr': 'kineski (tradicionalno pismo, Tajvan)',
        'hu': 'kínai (Hagyományos, Tajvan)',
        'id': 'Tionghoa (Tradisional, Taiwan)',
        'ie': 'chinesi (traditional, Taiwan)',
        'is': 'kínverska (hefðbundið, Taívan)',
        'it': 'cinese (tradizionale, Taiwan)',
        'ja': '中国語 (繁体字, 台湾)',
        'ko': '중국어 (번체, 대만)',
        'lt': 'kinų (tradiciniai, Taivanas)',
        'nb': 'kinesisk (tradisjonell, Taiwan)',
        'nl': 'Chinees (traditioneel, Taiwan)',
        'nn': 'kinesisk (tradisjonell, Taiwan)',
        'pl': 'chiński (tradycyjne, Tajwan)',
        'pt': 'chinês (tradicional, Taiwan)',
        'pt_BR': 'chinês (tradicional, Taiwan)',
        'ro': 'chineză (tradițională, Taiwan)',
        'ru': 'китайский (традиционная, Тайвань)',
        'sk': 'čínština (tradičné, Taiwan)',
        'sl': 'kitajščina (tradicionalna pisava, Tajvan)',
        'sr': 'кинески (традиционално кинеско писмо, Тајван)',
        'sr_Latn': 'kineski (tradicionalno kinesko pismo, Tajvan)',
        'sv': 'kinesiska (traditionell, Taiwan)',
        'th': 'จีน (ตัวเต็ม, ไต้หวัน)',
        'tr': 'Çince (Geleneksel, Tayvan)',
        'uk': 'китайська (традиційна, Тайвань)',
        'vi': 'Tiếng Trung (Phồn thể, Đài Loan)',
        'zh_CN': '中文 (繁体, 台湾)',
        'zh_TW': '中文 (繁體, 台灣)',
    },
}


completeness = {
    'eo': 56,
    'cs': 95,
    'de': 99,
    'hr': 27,
    'he': 95,
    'it': 95,
    'pt': 95,
    'zh_CN': 95,
    'ja': 84,
    'ru': 50,
    'hu': 68,
    'da': 95,
    'sr_Latn': 65,
    'vi': 41,
    'ca': 78,
    'et': 95,
    'lt': 71,
    'gl': 95,
    'eu': 95,
    'ko': 65,
    'zh_TW': 93,
    'is': 51,
    'id': 71,
    'nb': 73,
    'fo': 21,
    'fi': 95,
    'tr': 84,
    'el': 91,
    'sv': 95,
    'ar': 53,
    'bg': 64,
    'sl': 47,
    'fr': 95,
    'es': 84,
    'nn': 55,
    'sr': 68,
    'nl': 55,
    'fa': 85,
    'uk': 95,
    'sk': 65,
    'ro': 50,
    'pt_BR': 73,
    'pl': 99,
    'en': 100,
}
