<!--
SPDX-FileCopyrightText: © 2009 Back In Time Team

SPDX-License-Identifier: GPL-2.0-or-later

This file is part of the program "Back In Time" which is released under GNU
General Public License v2 (GPLv2). See LICENSES directory or go to
<https://spdx.org/licenses/GPL-2.0-or-later.html>
-->
[![Mailing list bit-dev@python.org](doc/maintain/_images/badge_bit-dev.svg)](https://mail.python.org/mailman3/lists/bit-dev.python.org/)
[![Mastodon @backintime@fosstodon.org](doc/maintain/_images/badge_mastodon.svg)](https://fosstodon.org/@backintime)

[![Build Status](https://app.travis-ci.com/bit-team/backintime.svg)](https://app.travis-ci.com/bit-team/backintime)
[![User manual Status](https://readthedocs.org/projects/backintime/badge/?version=latest)](https://backintime.readthedocs.io)
[![Translation status](https://translate.codeberg.org/widget/backintime/common/svg-badge.svg)](https://translate.codeberg.org/engage/backintime)
[![REUSE status](https://api.reuse.software/badge/github.com/bit-team/backintime)](https://api.reuse.software/info/github.com/bit-team/backintime)

# Back In Time
<sub>Copyright © 2008-2024 Oprea Dan, Bart de Koning, Richard Bailey,
Germar Reitze, Taylor Raack</sub><br />
<sub>Copyright © 2022 Christian Buhtz, Michael Büker, Jürgen Altfeld</sub>
 
_Back In Time_ is a comfortable and well-configurable graphical frontend for
incremental backups using [`rsync`](https://rsync.samba.org/), with a
command-line version also available. Modified files are transferred, while
unchanged files are linked to the new folder using rsync's hard link feature,
saving storage space. Restoring is straightforward via file manager, command
line or _Back In Time_ itself.

It is written in Python3 and available for all major GNU/Linux distributions
(but not for Windows or OS X/macOS) as command line tool `backintime` and GUI
`backintime-qt`. Backups can be scheduled and stored locally or remotely
through SSH.

More background info in [CONTRIBUTING](CONTRIBUTING.md) and
[HISTORY](HISTORY.md).

## Maintenance status

The project is in active development since the [new team](#the-team) joined in
summer 2022. Development is done voluntarily in spare time so things need to be
prioritized. Stick with us, we all ♥️ _Back In Time_. 😁

Current focus is on fixing
[major issues](https://github.com/bit-team/backintime/issues?q=is%3Aissue+is%3Aopen+label%3AHigh)
instead of implementing new
[features](https://github.com/bit-team/backintime/labels/Feature).
Stabilize the code base and its test suite is also a matter. Read the
[strategy outline](CONTRIBUTING.md#strategy-outline) for details.
Please see [CONTRIBUTING](CONTRIBUTING.md) if you are interested in the
development and have a look on
[open issues](https://github.com/bit-team/backintime/issues) especially
those labeled as [good first issues](https://github.com/bit-team/backintime/labels/GOOD%20FIRST%20ISSUE)
and [help wanted](https://github.com/bit-team/backintime/issues?q=is%3Aissue+is%3Aopen+label%3AHELP-WANTED).

## The team
The current team started in summer of 2022
(with [#1232](https://github.com/bit-team/backintime/issues/1232)) and
constitutes the project's 3rd generation of maintainers. Consisting of three
members with diverse backgrounds (@aryoda, @buhtz, @emtiu), the team benefits
from the assistance of the former maintainer, @Germar, who contributes from
behind the scenes.

All team members are engaged in every aspect of the project, including code
analysis, documentation, solving issues, and the implementation of new
features. This work is carried out voluntarily during their limited spare time.

# Index

- [Documentation](#documentation)
- [Contact & Social](#contact--social)
- [Installation](#installation)
- [Known Problems and Workarounds](#known-problems-and-workarounds)
- [Contributing and other ways to support the project](#contributing-and-other-ways-to-support-the-project)
- [Licenses](#licenses)

---

# Documentation

 * [FAQ - Frequently Asked Questions](FAQ.md)
 * [End user documentation](https://backintime.readthedocs.org/) (not totally up-to-date)
 * [Source code documentation for developers](https://backintime-dev.readthedocs.org)
   (**Disabled** and not up-2-tdate. Please open an issue if you need to use it.)

# Contact & Social

 * **Mailing list**:
   [bit-dev@python.org](https://mail.python.org/mailman3/lists/bit-dev.python.org/)
   can be used for **any topic**, question and idea related to _Back In
   Time_. Despite its name it is not restricted to development topics only.
 * **Fediverse** on **Mastodon**: [@backintime@fosstodon.org](https://fosstodon.org/@backintime)
 * **Bugs** & **Feature Requests**: [Issues section](https://github.com/bit-team/backintime/issues)

# Installation

_Back In Time_ is included in
[many GNU/Linux distributions](https://repology.org/project/backintime/badges).
Use their repositories to install it. If you want to contribute or using the
latest development version of _Back In Time_ please see section
[Build & Install](CONTRIBUTING.md#build--install) in
[`CONTRIBUTING.md`](CONTRIBUTING.md). Also the dependencies are described there.

# Known Problems and Workarounds

In the latest stable release:
- [OverflowError: Value 1702441408 out of range for UInt32](#overflowerror-value-1702441408-out-of-range-for-uint32)
- [File permissions handling and therefore possible non-differential backups](#file-permissions-handling-and-therefore-possible-non-differential-backups)
- [`qt_probing.py` may hang with high CPU usage when running BiT as `root` via `cron`](#qt_probingpy-may-hang-with-high-cpu-usage-when-running-bit-as-root-via-cron)
- [`SettingsDialog` object has no attribute `cbCopyUnsafeLinks`](#settingsDialog-object-has-no-attribute-cbcopyunsafelinks)

More problems described in
[this FAQ section](FAQ.md#problems-errors--solutions).

## OverflowError: Value 1702441408 out of range for UInt32
The _Back In Time_ GUI crashes and this exception appears in its terminal
output. Known to happen on restoring (#2084) and removing (#2192) of backups.
Assuming it might happen also on creating backups.

The current hypothesis the problem was introduced or happens more often since
the migration from PyQt version 5 to version 6 (BIT version 1.5.0).

A fix (PR #2099) will be released with
[upcoming 1.6.0](https://github.com/bit-team/backintime/milestone/34).
Don't use the latest development version and risk your data! Until the fix is
released, there is a tiny workaround described in that
[issue comment](https://github.com/bit-team/backintime/issues/2084#issuecomment-2787602155).

## File permissions handling and therefore possible non-differential backups

- In version 1.2.0, the handling of file permissions changed.
- In versions <= 1.1.24 (until 2017) all file permissions were set to
  `-rw-r--r--` in the backup target.
- In versions >= 1.2.0 (since 2019) `rsync` is executed with `--perms` option
  which tells `rsync` to preserve the source file permission.

Therefore backups can be larger and slower, especially the first backup after
upgrading to a version >= 1.2.0.

If you don't like the new behavior, you can use _Expert Options_ ->
_Paste additional options to rsync_ to add `--no-perms --no-group --no-owner`
to it. Note that the exact file permissions can still be found in
`fileinfo.bz2` and are also considered when restoring files.

## `qt_probing.py` may hang with high CPU usage when running BiT as `root` via `cron`

See the related issue [#1592](https://github.com/bit-team/backintime/issues/1592).

The only reliable work-around is to delete (or move into another folder)
the file `/usr/share/backintime/common/qt_probing.py`:

`mv /usr/share/backintime/common/qt_probing.py /usr/share/backintime/`

Renaming does *not* work!

## `SettingsDialog` object has no attribute `cbCopyUnsafeLinks`
Wenn adding a file or directory, that is in fact a symlink, to the _Include_
Tab in the _Manage profiles_ dialog, the BIT GUI crash and give the following
error in the terminal.

```pytb
Traceback (most recent call last):
  File "/usr/share/backintime/qt/manageprofiles/tab_include.py", line 185, in btn_include_add_clicked
    self._parent_dialog.cbCopyUnsafeLinks.isChecked() or
    ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
AttributeError: 'SettingsDialog' object has no attribute 'cbCopyUnsafeLinks'
```

Introduced in version `1.5.3`. Fixed in (upcoming) `1.6.0`.  See issue
[#2279](https://github.com/bit-team/backintime/issues/2279).

Workaround: Don't use a symlink but the linked target.

# Contributing and other ways to support the project
See [CONTRIBUTING](CONTRIBUTING.md) file for an overview about the projects
workflow and strategy.

# Licenses
Please read [`LICENSES.md`](LICENSES.md).

---

<sub>October 2025</sub>
