# apparmor.d - Full set of apparmor profiles
# Copyright (C) 2019-2021 Mikhail Morfikov
# Copyright (C) 2021-2024 Alexandre Pujol <alexandre@pujol.io>
# SPDX-License-Identifier: GPL-2.0-only

abi <abi/4.0>,

include <tunables/global>

@{exec_path} = @{bin}/{hostname,domainname,ypdomainname,nisdomainname,nisdomainname}
@{att} = /att/hostname/
profile hostname /{,usr/}bin/{hostname,domainname,ypdomainname,nisdomainname,nisdomainname}  flags=(attach_disconnected,attach_disconnected.path=@{att},complain) {
  include <abstractions/attached/base>
  include <abstractions/attached/consoles>
  include <abstractions/nameservice-strict>

  capability sys_admin,

  network inet dgram,
  network inet6 dgram,
  # network ip=127.0.0.1:53, TODO: abi 4.0
  network netlink raw,

  @{exec_path} mr,

  owner /dev/tty@{u8} rw,

  deny owner @{user_share_dirs}/gvfs-metadata/{,*} r,

  include if exists <local/hostname>
}

# vim:syntax=apparmor
